// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.paginators

import aws.sdk.kotlin.services.qbusiness.QBusinessClient
import aws.sdk.kotlin.services.qbusiness.model.Application
import aws.sdk.kotlin.services.qbusiness.model.Conversation
import aws.sdk.kotlin.services.qbusiness.model.DataSource
import aws.sdk.kotlin.services.qbusiness.model.DataSourceSyncJob
import aws.sdk.kotlin.services.qbusiness.model.DocumentDetails
import aws.sdk.kotlin.services.qbusiness.model.GetChatControlsConfigurationRequest
import aws.sdk.kotlin.services.qbusiness.model.GetChatControlsConfigurationResponse
import aws.sdk.kotlin.services.qbusiness.model.GroupSummary
import aws.sdk.kotlin.services.qbusiness.model.Index
import aws.sdk.kotlin.services.qbusiness.model.ListApplicationsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListApplicationsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListConversationsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListConversationsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListDataSourceSyncJobsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListDataSourceSyncJobsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.qbusiness.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.qbusiness.model.ListDocumentsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListDocumentsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListGroupsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListGroupsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListIndicesRequest
import aws.sdk.kotlin.services.qbusiness.model.ListIndicesResponse
import aws.sdk.kotlin.services.qbusiness.model.ListMessagesRequest
import aws.sdk.kotlin.services.qbusiness.model.ListMessagesResponse
import aws.sdk.kotlin.services.qbusiness.model.ListPluginsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListPluginsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListRetrieversRequest
import aws.sdk.kotlin.services.qbusiness.model.ListRetrieversResponse
import aws.sdk.kotlin.services.qbusiness.model.ListWebExperiencesRequest
import aws.sdk.kotlin.services.qbusiness.model.ListWebExperiencesResponse
import aws.sdk.kotlin.services.qbusiness.model.Message
import aws.sdk.kotlin.services.qbusiness.model.Plugin
import aws.sdk.kotlin.services.qbusiness.model.Retriever
import aws.sdk.kotlin.services.qbusiness.model.TopicConfiguration
import aws.sdk.kotlin.services.qbusiness.model.WebExperience
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetChatControlsConfigurationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetChatControlsConfigurationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetChatControlsConfigurationResponse]
 */
public fun QBusinessClient.getChatControlsConfigurationPaginated(initialRequest: GetChatControlsConfigurationRequest): Flow<GetChatControlsConfigurationResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getChatControlsConfigurationPaginated.getChatControlsConfiguration(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetChatControlsConfigurationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetChatControlsConfigurationResponse]
 */
public fun QBusinessClient.getChatControlsConfigurationPaginated(block: GetChatControlsConfigurationRequest.Builder.() -> Unit): Flow<GetChatControlsConfigurationResponse> =
    getChatControlsConfigurationPaginated(GetChatControlsConfigurationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getChatControlsConfigurationPaginated]
 * to access the nested member [TopicConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TopicConfiguration]
 */
@JvmName("getChatControlsConfigurationResponseTopicConfiguration")
public fun Flow<GetChatControlsConfigurationResponse>.topicConfigurations(): Flow<TopicConfiguration> =
    transform() { response ->
        response.topicConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun QBusinessClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest = ListApplicationsRequest { }): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun QBusinessClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [Application]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Application]
 */
@JvmName("listApplicationsResponseApplication")
public fun Flow<ListApplicationsResponse>.applications(): Flow<Application> =
    transform() { response ->
        response.applications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConversationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConversationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConversationsResponse]
 */
public fun QBusinessClient.listConversationsPaginated(initialRequest: ListConversationsRequest): Flow<ListConversationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConversationsPaginated.listConversations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConversationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConversationsResponse]
 */
public fun QBusinessClient.listConversationsPaginated(block: ListConversationsRequest.Builder.() -> Unit): Flow<ListConversationsResponse> =
    listConversationsPaginated(ListConversationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConversationsPaginated]
 * to access the nested member [Conversation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Conversation]
 */
@JvmName("listConversationsResponseConversation")
public fun Flow<ListConversationsResponse>.conversations(): Flow<Conversation> =
    transform() { response ->
        response.conversations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
public fun QBusinessClient.listDataSourcesPaginated(initialRequest: ListDataSourcesRequest): Flow<ListDataSourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourcesPaginated.listDataSources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
public fun QBusinessClient.listDataSourcesPaginated(block: ListDataSourcesRequest.Builder.() -> Unit): Flow<ListDataSourcesResponse> =
    listDataSourcesPaginated(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSourcesPaginated]
 * to access the nested member [DataSource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSource]
 */
@JvmName("listDataSourcesResponseDataSource")
public fun Flow<ListDataSourcesResponse>.dataSources(): Flow<DataSource> =
    transform() { response ->
        response.dataSources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSourceSyncJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSourceSyncJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourceSyncJobsResponse]
 */
public fun QBusinessClient.listDataSourceSyncJobsPaginated(initialRequest: ListDataSourceSyncJobsRequest): Flow<ListDataSourceSyncJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourceSyncJobsPaginated.listDataSourceSyncJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourceSyncJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourceSyncJobsResponse]
 */
public fun QBusinessClient.listDataSourceSyncJobsPaginated(block: ListDataSourceSyncJobsRequest.Builder.() -> Unit): Flow<ListDataSourceSyncJobsResponse> =
    listDataSourceSyncJobsPaginated(ListDataSourceSyncJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSourceSyncJobsPaginated]
 * to access the nested member [DataSourceSyncJob]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSourceSyncJob]
 */
@JvmName("listDataSourceSyncJobsResponseDataSourceSyncJob")
public fun Flow<ListDataSourceSyncJobsResponse>.history(): Flow<DataSourceSyncJob> =
    transform() { response ->
        response.history?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDocumentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDocumentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDocumentsResponse]
 */
public fun QBusinessClient.listDocumentsPaginated(initialRequest: ListDocumentsRequest): Flow<ListDocumentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDocumentsPaginated.listDocuments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDocumentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDocumentsResponse]
 */
public fun QBusinessClient.listDocumentsPaginated(block: ListDocumentsRequest.Builder.() -> Unit): Flow<ListDocumentsResponse> =
    listDocumentsPaginated(ListDocumentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDocumentsPaginated]
 * to access the nested member [DocumentDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DocumentDetails]
 */
@JvmName("listDocumentsResponseDocumentDetails")
public fun Flow<ListDocumentsResponse>.documentDetailList(): Flow<DocumentDetails> =
    transform() { response ->
        response.documentDetailList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun QBusinessClient.listGroupsPaginated(initialRequest: ListGroupsRequest): Flow<ListGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupsPaginated.listGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun QBusinessClient.listGroupsPaginated(block: ListGroupsRequest.Builder.() -> Unit): Flow<ListGroupsResponse> =
    listGroupsPaginated(ListGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupsPaginated]
 * to access the nested member [GroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupSummary]
 */
@JvmName("listGroupsResponseGroupSummary")
public fun Flow<ListGroupsResponse>.items(): Flow<GroupSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIndicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIndicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIndicesResponse]
 */
public fun QBusinessClient.listIndicesPaginated(initialRequest: ListIndicesRequest): Flow<ListIndicesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIndicesPaginated.listIndices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIndicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIndicesResponse]
 */
public fun QBusinessClient.listIndicesPaginated(block: ListIndicesRequest.Builder.() -> Unit): Flow<ListIndicesResponse> =
    listIndicesPaginated(ListIndicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIndicesPaginated]
 * to access the nested member [Index]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Index]
 */
@JvmName("listIndicesResponseIndex")
public fun Flow<ListIndicesResponse>.indices(): Flow<Index> =
    transform() { response ->
        response.indices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMessagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMessagesResponse]
 */
public fun QBusinessClient.listMessagesPaginated(initialRequest: ListMessagesRequest): Flow<ListMessagesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMessagesPaginated.listMessages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMessagesResponse]
 */
public fun QBusinessClient.listMessagesPaginated(block: ListMessagesRequest.Builder.() -> Unit): Flow<ListMessagesResponse> =
    listMessagesPaginated(ListMessagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMessagesPaginated]
 * to access the nested member [Message]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Message]
 */
@JvmName("listMessagesResponseMessage")
public fun Flow<ListMessagesResponse>.messages(): Flow<Message> =
    transform() { response ->
        response.messages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPluginsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPluginsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPluginsResponse]
 */
public fun QBusinessClient.listPluginsPaginated(initialRequest: ListPluginsRequest): Flow<ListPluginsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPluginsPaginated.listPlugins(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPluginsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPluginsResponse]
 */
public fun QBusinessClient.listPluginsPaginated(block: ListPluginsRequest.Builder.() -> Unit): Flow<ListPluginsResponse> =
    listPluginsPaginated(ListPluginsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPluginsPaginated]
 * to access the nested member [Plugin]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Plugin]
 */
@JvmName("listPluginsResponsePlugin")
public fun Flow<ListPluginsResponse>.plugins(): Flow<Plugin> =
    transform() { response ->
        response.plugins?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRetrieversResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRetrieversRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRetrieversResponse]
 */
public fun QBusinessClient.listRetrieversPaginated(initialRequest: ListRetrieversRequest): Flow<ListRetrieversResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRetrieversPaginated.listRetrievers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRetrieversResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRetrieversResponse]
 */
public fun QBusinessClient.listRetrieversPaginated(block: ListRetrieversRequest.Builder.() -> Unit): Flow<ListRetrieversResponse> =
    listRetrieversPaginated(ListRetrieversRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRetrieversPaginated]
 * to access the nested member [Retriever]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Retriever]
 */
@JvmName("listRetrieversResponseRetriever")
public fun Flow<ListRetrieversResponse>.retrievers(): Flow<Retriever> =
    transform() { response ->
        response.retrievers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWebExperiencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWebExperiencesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebExperiencesResponse]
 */
public fun QBusinessClient.listWebExperiencesPaginated(initialRequest: ListWebExperiencesRequest): Flow<ListWebExperiencesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWebExperiencesPaginated.listWebExperiences(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWebExperiencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebExperiencesResponse]
 */
public fun QBusinessClient.listWebExperiencesPaginated(block: ListWebExperiencesRequest.Builder.() -> Unit): Flow<ListWebExperiencesResponse> =
    listWebExperiencesPaginated(ListWebExperiencesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWebExperiencesPaginated]
 * to access the nested member [WebExperience]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WebExperience]
 */
@JvmName("listWebExperiencesResponseWebExperience")
public fun Flow<ListWebExperiencesResponse>.webExperiences(): Flow<WebExperience> =
    transform() { response ->
        response.webExperiences?.forEach {
            emit(it)
        }
    }
