// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information on boosting `STRING_LIST` type document attributes.
 *
 * For `STRING` and `STRING_LIST` type document attributes to be used for boosting on the console and the API, they must be enabled for search using the [DocumentAttributeConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html) object of the [UpdateIndex](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html) API. If you haven't enabled searching on these attributes, you can't boost attributes of these data types on either the console or the API.
 *
 * For more information on how boosting document attributes work in Amazon Q Business, see [Boosting using document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
 */
public class StringListAttributeBoostingConfiguration private constructor(builder: Builder) {
    /**
     * Specifies how much a document attribute is boosted.
     */
    public val boostingLevel: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingLevel = requireNotNull(builder.boostingLevel) { "A non-null value must be provided for boostingLevel" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StringListAttributeBoostingConfiguration(")
        append("boostingLevel=$boostingLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = boostingLevel.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StringListAttributeBoostingConfiguration

        if (boostingLevel != other.boostingLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies how much a document attribute is boosted.
         */
        public var boostingLevel: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration) : this() {
            this.boostingLevel = x.boostingLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration = StringListAttributeBoostingConfiguration(this)

        internal fun correctErrors(): Builder {
            if (boostingLevel == null) boostingLevel = DocumentAttributeBoostingLevel.SdkUnknown("no value provided")
            return this
        }
    }
}
