// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the OIDC-compliant identity provider (IdP) used to authenticate end users of an Amazon Q Business web experience.
 */
public class OpenIdConnectProviderConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a Secrets Manager secret containing the OIDC client secret.
     */
    public val secretsArn: kotlin.String = requireNotNull(builder.secretsArn) { "A non-null value must be provided for secretsArn" }
    /**
     * An IAM role with permissions to access KMS to decrypt the Secrets Manager secret containing your OIDC client secret.
     */
    public val secretsRole: kotlin.String = requireNotNull(builder.secretsRole) { "A non-null value must be provided for secretsRole" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.OpenIdConnectProviderConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenIdConnectProviderConfiguration(")
        append("secretsArn=$secretsArn,")
        append("secretsRole=$secretsRole")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = secretsArn.hashCode()
        result = 31 * result + (secretsRole.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenIdConnectProviderConfiguration

        if (secretsArn != other.secretsArn) return false
        if (secretsRole != other.secretsRole) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.OpenIdConnectProviderConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a Secrets Manager secret containing the OIDC client secret.
         */
        public var secretsArn: kotlin.String? = null
        /**
         * An IAM role with permissions to access KMS to decrypt the Secrets Manager secret containing your OIDC client secret.
         */
        public var secretsRole: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.OpenIdConnectProviderConfiguration) : this() {
            this.secretsArn = x.secretsArn
            this.secretsRole = x.secretsRole
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.OpenIdConnectProviderConfiguration = OpenIdConnectProviderConfiguration(this)

        internal fun correctErrors(): Builder {
            if (secretsArn == null) secretsArn = ""
            if (secretsRole == null) secretsRole = ""
            return this
        }
    }
}
