// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information on boosting `NUMBER` type document attributes.
 *
 * For more information on how boosting document attributes work in Amazon Q Business, see [Boosting using document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
 */
public class NumberAttributeBoostingConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the duration, in seconds, of a boost applies to a `NUMBER` type document attribute.
     */
    public val boostingLevel: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingLevel = requireNotNull(builder.boostingLevel) { "A non-null value must be provided for boostingLevel" }
    /**
     * Specifies how much a document attribute is boosted.
     */
    public val boostingType: aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingType? = builder.boostingType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NumberAttributeBoostingConfiguration(")
        append("boostingLevel=$boostingLevel,")
        append("boostingType=$boostingType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = boostingLevel.hashCode()
        result = 31 * result + (boostingType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NumberAttributeBoostingConfiguration

        if (boostingLevel != other.boostingLevel) return false
        if (boostingType != other.boostingType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the duration, in seconds, of a boost applies to a `NUMBER` type document attribute.
         */
        public var boostingLevel: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingLevel? = null
        /**
         * Specifies how much a document attribute is boosted.
         */
        public var boostingType: aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration) : this() {
            this.boostingLevel = x.boostingLevel
            this.boostingType = x.boostingType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration = NumberAttributeBoostingConfiguration(this)

        internal fun correctErrors(): Builder {
            if (boostingLevel == null) boostingLevel = DocumentAttributeBoostingLevel.SdkUnknown("no value provided")
            return this
        }
    }
}
