// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The condition used for the target document attribute or metadata field when ingesting documents into Amazon Q Business. You use this with `DocumentAttributeTarget`[](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html) to apply the condition.
 *
 * For example, you can create the 'Department' target field and have it prefill department names associated with the documents based on information in the 'Source_URI' field. Set the condition that if the 'Source_URI' field contains 'financial' in its URI value, then prefill the target field 'Department' with the target value 'Finance' for the document.
 *
 * Amazon Q Business can't create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using `DocumentAttributeTarget`. Amazon Q Business then will map your newly created metadata field to your index field.
 */
public class DocumentAttributeCondition private constructor(builder: Builder) {
    /**
     * The identifier of the document attribute used for the condition.
     *
     * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
     *
     * Amazon Q Business currently doesn't support `_document_body` as an attribute key used for the condition.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The identifier of the document attribute used for the condition.
     *
     * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
     *
     * Amazon Q Business currently does not support `_document_body` as an attribute key used for the condition.
     */
    public val operator: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConditionOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The value of a document attribute. You can only provide one value for a document attribute.
     */
    public val value: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeValue? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentAttributeCondition(")
        append("key=$key,")
        append("operator=$operator,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentAttributeCondition

        if (key != other.key) return false
        if (operator != other.operator) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the document attribute used for the condition.
         *
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
         *
         * Amazon Q Business currently doesn't support `_document_body` as an attribute key used for the condition.
         */
        public var key: kotlin.String? = null
        /**
         * The identifier of the document attribute used for the condition.
         *
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
         *
         * Amazon Q Business currently does not support `_document_body` as an attribute key used for the condition.
         */
        public var operator: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConditionOperator? = null
        /**
         * The value of a document attribute. You can only provide one value for a document attribute.
         */
        public var value: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition) : this() {
            this.key = x.key
            this.operator = x.operator
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition = DocumentAttributeCondition(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (operator == null) operator = DocumentEnrichmentConditionOperator.SdkUnknown("no value provided")
            return this
        }
    }
}
