// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information on boosting `DATE` type document attributes.
 *
 * For more information on how boosting document attributes work in Amazon Q Business, see [Boosting using document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
 */
public class DateAttributeBoostingConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the duration, in seconds, of a boost applies to a `DATE` type document attribute.
     */
    public val boostingDurationInSeconds: kotlin.Long? = builder.boostingDurationInSeconds
    /**
     * Specifies how much a document attribute is boosted.
     */
    public val boostingLevel: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingLevel = requireNotNull(builder.boostingLevel) { "A non-null value must be provided for boostingLevel" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DateAttributeBoostingConfiguration(")
        append("boostingDurationInSeconds=$boostingDurationInSeconds,")
        append("boostingLevel=$boostingLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = boostingDurationInSeconds?.hashCode() ?: 0
        result = 31 * result + (boostingLevel.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DateAttributeBoostingConfiguration

        if (boostingDurationInSeconds != other.boostingDurationInSeconds) return false
        if (boostingLevel != other.boostingLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the duration, in seconds, of a boost applies to a `DATE` type document attribute.
         */
        public var boostingDurationInSeconds: kotlin.Long? = null
        /**
         * Specifies how much a document attribute is boosted.
         */
        public var boostingLevel: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration) : this() {
            this.boostingDurationInSeconds = x.boostingDurationInSeconds
            this.boostingLevel = x.boostingLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration = DateAttributeBoostingConfiguration(this)

        internal fun correctErrors(): Builder {
            if (boostingLevel == null) boostingLevel = DocumentAttributeBoostingLevel.SdkUnknown("no value provided")
            return this
        }
    }
}
