// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A configuration event activated by an end user request to select a specific chat mode.
 */
public class ConfigurationEvent private constructor(builder: Builder) {
    /**
     * Enables filtering of responses based on document attributes or metadata fields.
     */
    public val attributeFilter: aws.sdk.kotlin.services.qbusiness.model.AttributeFilter? = builder.attributeFilter
    /**
     * The chat modes available to an Amazon Q Business end user.
     * + `RETRIEVAL_MODE` - The default chat mode for an Amazon Q Business application. When this mode is enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q Business application.
     * + `CREATOR_MODE` - By selecting this mode, users can choose to generate responses only from the LLM knowledge, without consulting connected data sources, for a chat request.
     * + `PLUGIN_MODE` - By selecting this mode, users can choose to use plugins in chat.
     *
     * For more information, see [Admin controls and guardrails](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html), [Plugins](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html), and [Conversation settings](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
     */
    public val chatMode: aws.sdk.kotlin.services.qbusiness.model.ChatMode? = builder.chatMode
    /**
     * Configuration information for Amazon Q Business conversation modes.
     *
     * For more information, see [Admin controls and guardrails](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html) and [Conversation settings](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
     */
    public val chatModeConfiguration: aws.sdk.kotlin.services.qbusiness.model.ChatModeConfiguration? = builder.chatModeConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.ConfigurationEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigurationEvent(")
        append("attributeFilter=$attributeFilter,")
        append("chatMode=$chatMode,")
        append("chatModeConfiguration=$chatModeConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeFilter?.hashCode() ?: 0
        result = 31 * result + (chatMode?.hashCode() ?: 0)
        result = 31 * result + (chatModeConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigurationEvent

        if (attributeFilter != other.attributeFilter) return false
        if (chatMode != other.chatMode) return false
        if (chatModeConfiguration != other.chatModeConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.ConfigurationEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Enables filtering of responses based on document attributes or metadata fields.
         */
        public var attributeFilter: aws.sdk.kotlin.services.qbusiness.model.AttributeFilter? = null
        /**
         * The chat modes available to an Amazon Q Business end user.
         * + `RETRIEVAL_MODE` - The default chat mode for an Amazon Q Business application. When this mode is enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q Business application.
         * + `CREATOR_MODE` - By selecting this mode, users can choose to generate responses only from the LLM knowledge, without consulting connected data sources, for a chat request.
         * + `PLUGIN_MODE` - By selecting this mode, users can choose to use plugins in chat.
         *
         * For more information, see [Admin controls and guardrails](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html), [Plugins](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html), and [Conversation settings](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
         */
        public var chatMode: aws.sdk.kotlin.services.qbusiness.model.ChatMode? = null
        /**
         * Configuration information for Amazon Q Business conversation modes.
         *
         * For more information, see [Admin controls and guardrails](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html) and [Conversation settings](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
         */
        public var chatModeConfiguration: aws.sdk.kotlin.services.qbusiness.model.ChatModeConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.ConfigurationEvent) : this() {
            this.attributeFilter = x.attributeFilter
            this.chatMode = x.chatMode
            this.chatModeConfiguration = x.chatModeConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.ConfigurationEvent = ConfigurationEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.AttributeFilter] inside the given [block]
         */
        public fun attributeFilter(block: aws.sdk.kotlin.services.qbusiness.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.attributeFilter = aws.sdk.kotlin.services.qbusiness.model.AttributeFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
