// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.UpdateWebExperienceRequest
import aws.sdk.kotlin.services.qbusiness.model.WebExperienceAuthConfiguration
import aws.sdk.kotlin.services.qbusiness.model.WebExperienceSamplePromptsControlMode
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateWebExperienceOperationSerializer: HttpSerializer.NonStreaming<UpdateWebExperienceRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateWebExperienceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.webExperienceId) { "webExperienceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode("${input.applicationId}"))
                add(PercentEncoding.Path.encode("experiences"))
                add(PercentEncoding.SmithyLabel.encode("${input.webExperienceId}"))
            }
        }

        val payload = serializeUpdateWebExperienceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateWebExperienceOperationBody(context: ExecutionContext, input: UpdateWebExperienceRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHENTICATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authenticationConfiguration"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SAMPLEPROMPTSCONTROLMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("samplePromptsControlMode"))
    val SUBTITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subtitle"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("title"))
    val WELCOMEMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("welcomeMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONCONFIGURATION_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SAMPLEPROMPTSCONTROLMODE_DESCRIPTOR)
        field(SUBTITLE_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
        field(WELCOMEMESSAGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authenticationConfiguration?.let { field(AUTHENTICATIONCONFIGURATION_DESCRIPTOR, it, ::serializeWebExperienceAuthConfigurationDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.samplePromptsControlMode?.let { field(SAMPLEPROMPTSCONTROLMODE_DESCRIPTOR, it.value) }
        input.subtitle?.let { field(SUBTITLE_DESCRIPTOR, it) }
        input.title?.let { field(TITLE_DESCRIPTOR, it) }
        input.welcomeMessage?.let { field(WELCOMEMESSAGE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
