// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.CustomPluginConfiguration
import aws.sdk.kotlin.services.qbusiness.model.PluginAuthConfiguration
import aws.sdk.kotlin.services.qbusiness.model.PluginState
import aws.sdk.kotlin.services.qbusiness.model.UpdatePluginRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdatePluginOperationSerializer: HttpSerializer.NonStreaming<UpdatePluginRequest> {
    override fun serialize(context: ExecutionContext, input: UpdatePluginRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.pluginId) { "pluginId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode("${input.applicationId}"))
                add(PercentEncoding.Path.encode("plugins"))
                add(PercentEncoding.SmithyLabel.encode("${input.pluginId}"))
            }
        }

        val payload = serializeUpdatePluginOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdatePluginOperationBody(context: ExecutionContext, input: UpdatePluginRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authConfiguration"))
    val CUSTOMPLUGINCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("customPluginConfiguration"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("displayName"))
    val SERVERURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serverUrl"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("state"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHCONFIGURATION_DESCRIPTOR)
        field(CUSTOMPLUGINCONFIGURATION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(SERVERURL_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authConfiguration?.let { field(AUTHCONFIGURATION_DESCRIPTOR, it, ::serializePluginAuthConfigurationDocument) }
        input.customPluginConfiguration?.let { field(CUSTOMPLUGINCONFIGURATION_DESCRIPTOR, it, ::serializeCustomPluginConfigurationDocument) }
        input.displayName?.let { field(DISPLAYNAME_DESCRIPTOR, it) }
        input.serverUrl?.let { field(SERVERURL_DESCRIPTOR, it) }
        input.state?.let { field(STATE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
