// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.GroupMembers
import aws.sdk.kotlin.services.qbusiness.model.MembershipType
import aws.sdk.kotlin.services.qbusiness.model.PutGroupRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutGroupOperationSerializer: HttpSerializer.NonStreaming<PutGroupRequest> {
    override fun serialize(context: ExecutionContext, input: PutGroupRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.indexId) { "indexId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode("${input.applicationId}"))
                add(PercentEncoding.Path.encode("indices"))
                add(PercentEncoding.SmithyLabel.encode("${input.indexId}"))
                add(PercentEncoding.Path.encode("groups"))
            }
        }

        val payload = serializePutGroupOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutGroupOperationBody(context: ExecutionContext, input: PutGroupRequest): ByteArray {
    val serializer = JsonSerializer()
    val DATASOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataSourceId"))
    val GROUPMEMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("groupMembers"))
    val GROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("groupName"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASOURCEID_DESCRIPTOR)
        field(GROUPMEMBERS_DESCRIPTOR)
        field(GROUPNAME_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dataSourceId?.let { field(DATASOURCEID_DESCRIPTOR, it) }
        input.groupMembers?.let { field(GROUPMEMBERS_DESCRIPTOR, it, ::serializeGroupMembersDocument) }
        input.groupName?.let { field(GROUPNAME_DESCRIPTOR, it) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
