// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.MessageUsefulnessFeedback
import aws.sdk.kotlin.services.qbusiness.model.PutFeedbackRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class PutFeedbackOperationSerializer: HttpSerializer.NonStreaming<PutFeedbackRequest> {
    override fun serialize(context: ExecutionContext, input: PutFeedbackRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.conversationId) { "conversationId is bound to the URI and must not be null" }
            requireNotNull(input.messageId) { "messageId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode("${input.applicationId}"))
                add(PercentEncoding.Path.encode("conversations"))
                add(PercentEncoding.SmithyLabel.encode("${input.conversationId}"))
                add(PercentEncoding.Path.encode("messages"))
                add(PercentEncoding.SmithyLabel.encode("${input.messageId}"))
                add(PercentEncoding.Path.encode("feedback"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.userId != null) add("userId", input.userId)
            }
        }

        val payload = serializePutFeedbackOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutFeedbackOperationBody(context: ExecutionContext, input: PutFeedbackRequest): ByteArray {
    val serializer = JsonSerializer()
    val MESSAGECOPIEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("messageCopiedAt"))
    val MESSAGEUSEFULNESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("messageUsefulness"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MESSAGECOPIEDAT_DESCRIPTOR)
        field(MESSAGEUSEFULNESS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.messageCopiedAt?.let { field(MESSAGECOPIEDAT_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.messageUsefulness?.let { field(MESSAGEUSEFULNESS_DESCRIPTOR, it, ::serializeMessageUsefulnessFeedbackDocument) }
    }
    return serializer.toByteArray()
}
