// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.ListGroupsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListGroupsOperationSerializer: HttpSerializer.NonStreaming<ListGroupsRequest> {
    override fun serialize(context: ExecutionContext, input: ListGroupsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.indexId) { "indexId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode("${input.applicationId}"))
                add(PercentEncoding.Path.encode("indices"))
                add(PercentEncoding.SmithyLabel.encode("${input.indexId}"))
                add(PercentEncoding.Path.encode("groups"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.dataSourceId != null) add("dataSourceId", input.dataSourceId)
                if (input.maxResults != null) add("maxResults", "${input.maxResults}")
                if (input.nextToken != null) add("nextToken", input.nextToken)
                if (input.updatedEarlierThan != null) add("updatedEarlierThan", input.updatedEarlierThan.format(TimestampFormat.ISO_8601))
            }
        }

        return builder
    }
}
