// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.ActionReview
import aws.sdk.kotlin.services.qbusiness.model.AttachmentOutput
import aws.sdk.kotlin.services.qbusiness.model.AuthChallengeRequest
import aws.sdk.kotlin.services.qbusiness.model.ChatSyncResponse
import aws.sdk.kotlin.services.qbusiness.model.QBusinessException
import aws.sdk.kotlin.services.qbusiness.model.SourceAttribution
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ChatSyncOperationDeserializer: HttpDeserializer.NonStreaming<ChatSyncResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ChatSyncResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwChatSyncError(context, call, payload)
        }
        val builder = ChatSyncResponse.Builder()

        if (payload != null) {
            deserializeChatSyncOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwChatSyncError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QBusinessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LicenseNotFoundException" -> LicenseNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeChatSyncOperationBody(builder: ChatSyncResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONREVIEW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("actionReview"))
    val AUTHCHALLENGEREQUEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authChallengeRequest"))
    val CONVERSATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("conversationId"))
    val FAILEDATTACHMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedAttachments"))
    val SOURCEATTRIBUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sourceAttributions"))
    val SYSTEMMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("systemMessage"))
    val SYSTEMMESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("systemMessageId"))
    val USERMESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("userMessageId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONREVIEW_DESCRIPTOR)
        field(AUTHCHALLENGEREQUEST_DESCRIPTOR)
        field(CONVERSATIONID_DESCRIPTOR)
        field(FAILEDATTACHMENTS_DESCRIPTOR)
        field(SOURCEATTRIBUTIONS_DESCRIPTOR)
        field(SYSTEMMESSAGE_DESCRIPTOR)
        field(SYSTEMMESSAGEID_DESCRIPTOR)
        field(USERMESSAGEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONREVIEW_DESCRIPTOR.index -> builder.actionReview = deserializeActionReviewDocument(deserializer)
                AUTHCHALLENGEREQUEST_DESCRIPTOR.index -> builder.authChallengeRequest = deserializeAuthChallengeRequestDocument(deserializer)
                CONVERSATIONID_DESCRIPTOR.index -> builder.conversationId = deserializeString()
                FAILEDATTACHMENTS_DESCRIPTOR.index -> builder.failedAttachments =
                    deserializer.deserializeList(FAILEDATTACHMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<AttachmentOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAttachmentOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SOURCEATTRIBUTIONS_DESCRIPTOR.index -> builder.sourceAttributions =
                    deserializer.deserializeList(SOURCEATTRIBUTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<SourceAttribution?>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSourceAttributionDocument(deserializer) } else { deserializeNull() }
                            col0.add(el0)
                        }
                        col0
                    }
                SYSTEMMESSAGE_DESCRIPTOR.index -> builder.systemMessage = deserializeString()
                SYSTEMMESSAGEID_DESCRIPTOR.index -> builder.systemMessageId = deserializeString()
                USERMESSAGEID_DESCRIPTOR.index -> builder.userMessageId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
