// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.ChatOutputStream
import aws.sdk.kotlin.services.qbusiness.model.ChatResponse
import aws.sdk.kotlin.services.qbusiness.model.QBusinessException
import aws.smithy.kotlin.runtime.ClientException
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.MessageType
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.decodeFrames
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.type
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class ChatOperationDeserializer: HttpDeserializer.Streaming<ChatResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ChatResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            val payload = response.body.readAll()
            throwChatError(context, call, payload)
        }
        val builder = ChatResponse.Builder()

        deserializeChatOperationBody(builder, call)
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwChatError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QBusinessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LicenseNotFoundException" -> LicenseNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeChatOperationBody(builder: ChatResponse.Builder, call: HttpCall) {
    val chan = call.response.body.toSdkByteReadChannel(call) ?: return
    val frames = decodeFrames(chan)
    val events = frames
        .map { message ->
            when (val mt = message.type()) {
                is MessageType.Event -> when (mt.shapeType) {
                    "textEvent" -> {
                        val e = deserializeTextOutputEventPayload(message.payload)
                        ChatOutputStream.TextEvent(e)
                    }
                    "metadataEvent" -> {
                        val e = deserializeMetadataEventPayload(message.payload)
                        ChatOutputStream.MetadataEvent(e)
                    }
                    "actionReviewEvent" -> {
                        val e = deserializeActionReviewEventPayload(message.payload)
                        ChatOutputStream.ActionReviewEvent(e)
                    }
                    "failedAttachmentEvent" -> {
                        val e = deserializeFailedAttachmentEventPayload(message.payload)
                        ChatOutputStream.FailedAttachmentEvent(e)
                    }
                    "authChallengeRequestEvent" -> {
                        val e = deserializeAuthChallengeRequestEventPayload(message.payload)
                        ChatOutputStream.AuthChallengeRequestEvent(e)
                    }
                    else -> ChatOutputStream.SdkUnknown
                }
                is MessageType.Exception -> when (mt.shapeType) {
                    else -> throw QBusinessException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw QBusinessException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }

    builder.outputStream = events
}
