// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A message in an Amazon Q Business web experience.
 */
public class Message private constructor(builder: Builder) {
    /**
     * Performs an Amazon Q Business plugin action during a non-streaming chat conversation.
     */
    public val actionExecution: aws.sdk.kotlin.services.qbusiness.model.ActionExecution? = builder.actionExecution
    /**
     * An output event that Amazon Q Business returns to an user who wants to perform a plugin action during a non-streaming chat conversation. It contains information about the selected action with a list of possible user input fields, some pre-populated by Amazon Q Business.
     */
    public val actionReview: aws.sdk.kotlin.services.qbusiness.model.ActionReview? = builder.actionReview
    /**
     * A file directly uploaded into an Amazon Q Business web experience chat.
     */
    public val attachments: List<AttachmentOutput>? = builder.attachments
    /**
     * The content of the Amazon Q Business web experience message.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The identifier of the Amazon Q Business web experience message.
     */
    public val messageId: kotlin.String? = builder.messageId
    /**
     * The source documents used to generate Amazon Q Business web experience message.
     */
    public val sourceAttribution: List<SourceAttribution?>? = builder.sourceAttribution
    /**
     * The timestamp of the first Amazon Q Business web experience message.
     */
    public val time: aws.smithy.kotlin.runtime.time.Instant? = builder.time
    /**
     * The type of Amazon Q Business message, whether `HUMAN` or `AI` generated.
     */
    public val type: aws.sdk.kotlin.services.qbusiness.model.MessageType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.Message = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Message(")
        append("actionExecution=$actionExecution,")
        append("actionReview=$actionReview,")
        append("attachments=$attachments,")
        append("body=$body,")
        append("messageId=$messageId,")
        append("sourceAttribution=$sourceAttribution,")
        append("time=$time,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionExecution?.hashCode() ?: 0
        result = 31 * result + (actionReview?.hashCode() ?: 0)
        result = 31 * result + (attachments?.hashCode() ?: 0)
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (sourceAttribution?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Message

        if (actionExecution != other.actionExecution) return false
        if (actionReview != other.actionReview) return false
        if (attachments != other.attachments) return false
        if (body != other.body) return false
        if (messageId != other.messageId) return false
        if (sourceAttribution != other.sourceAttribution) return false
        if (time != other.time) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.Message = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Performs an Amazon Q Business plugin action during a non-streaming chat conversation.
         */
        public var actionExecution: aws.sdk.kotlin.services.qbusiness.model.ActionExecution? = null
        /**
         * An output event that Amazon Q Business returns to an user who wants to perform a plugin action during a non-streaming chat conversation. It contains information about the selected action with a list of possible user input fields, some pre-populated by Amazon Q Business.
         */
        public var actionReview: aws.sdk.kotlin.services.qbusiness.model.ActionReview? = null
        /**
         * A file directly uploaded into an Amazon Q Business web experience chat.
         */
        public var attachments: List<AttachmentOutput>? = null
        /**
         * The content of the Amazon Q Business web experience message.
         */
        public var body: kotlin.String? = null
        /**
         * The identifier of the Amazon Q Business web experience message.
         */
        public var messageId: kotlin.String? = null
        /**
         * The source documents used to generate Amazon Q Business web experience message.
         */
        public var sourceAttribution: List<SourceAttribution?>? = null
        /**
         * The timestamp of the first Amazon Q Business web experience message.
         */
        public var time: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of Amazon Q Business message, whether `HUMAN` or `AI` generated.
         */
        public var type: aws.sdk.kotlin.services.qbusiness.model.MessageType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.Message) : this() {
            this.actionExecution = x.actionExecution
            this.actionReview = x.actionReview
            this.attachments = x.attachments
            this.body = x.body
            this.messageId = x.messageId
            this.sourceAttribution = x.sourceAttribution
            this.time = x.time
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.Message = Message(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.ActionExecution] inside the given [block]
         */
        public fun actionExecution(block: aws.sdk.kotlin.services.qbusiness.model.ActionExecution.Builder.() -> kotlin.Unit) {
            this.actionExecution = aws.sdk.kotlin.services.qbusiness.model.ActionExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.ActionReview] inside the given [block]
         */
        public fun actionReview(block: aws.sdk.kotlin.services.qbusiness.model.ActionReview.Builder.() -> kotlin.Unit) {
            this.actionReview = aws.sdk.kotlin.services.qbusiness.model.ActionReview.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
