// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of documents that could not be removed from an Amazon Q Business index. Each entry contains an error message that indicates why the document couldn't be removed from the index.
 */
public class FailedDocument private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Q Business data source connector that contains the failed document.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * An explanation for why the document couldn't be removed from the index.
     */
    public val error: aws.sdk.kotlin.services.qbusiness.model.ErrorDetail? = builder.error
    /**
     * The identifier of the document that couldn't be removed from the Amazon Q Business index.
     */
    public val id: kotlin.String? = builder.id

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.FailedDocument = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailedDocument(")
        append("dataSourceId=$dataSourceId,")
        append("error=$error,")
        append("id=$id")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceId?.hashCode() ?: 0
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailedDocument

        if (dataSourceId != other.dataSourceId) return false
        if (error != other.error) return false
        if (id != other.id) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.FailedDocument = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Q Business data source connector that contains the failed document.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * An explanation for why the document couldn't be removed from the index.
         */
        public var error: aws.sdk.kotlin.services.qbusiness.model.ErrorDetail? = null
        /**
         * The identifier of the document that couldn't be removed from the Amazon Q Business index.
         */
        public var id: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.FailedDocument) : this() {
            this.dataSourceId = x.dataSourceId
            this.error = x.error
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.FailedDocument = FailedDocument(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.ErrorDetail] inside the given [block]
         */
        public fun error(block: aws.sdk.kotlin.services.qbusiness.model.ErrorDetail.Builder.() -> kotlin.Unit) {
            this.error = aws.sdk.kotlin.services.qbusiness.model.ErrorDetail.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
