// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * Provides information on boosting supported Amazon Q Business document attribute types. When an end user chat query matches document attributes that have been boosted, Amazon Q Business prioritizes generating responses from content that matches the boosted document attributes.
 *
 * For `STRING` and `STRING_LIST` type document attributes to be used for boosting on the console and the API, they must be enabled for search using the [DocumentAttributeConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html) object of the [UpdateIndex](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html) API. If you haven't enabled searching on these attributes, you can't boost attributes of these data types on either the console or the API.
 *
 * For more information on how boosting document attributes work in Amazon Q Business, see [Boosting using document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
 */
public sealed class DocumentAttributeBoostingConfiguration {
    /**
     * Provides information on boosting `DATE` type document attributes.
     */
    public data class DateConfiguration(val value: aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration) : aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingConfiguration() {
    }

    /**
     * Provides information on boosting `NUMBER` type document attributes.
     */
    public data class NumberConfiguration(val value: aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration) : aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingConfiguration() {
    }

    /**
     * Provides information on boosting `STRING` type document attributes.
     */
    public data class StringConfiguration(val value: aws.sdk.kotlin.services.qbusiness.model.StringAttributeBoostingConfiguration) : aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingConfiguration() {
    }

    /**
     * Provides information on boosting `STRING_LIST` type document attributes.
     */
    public data class StringListConfiguration(val value: aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration) : aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingConfiguration() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeBoostingConfiguration() {
    }

    /**
     * Casts this [DocumentAttributeBoostingConfiguration] as a [DateConfiguration] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration] value. Throws an exception if the [DocumentAttributeBoostingConfiguration] is not a
     * [DateConfiguration].
     */
    public fun asDateConfiguration(): aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration = (this as DocumentAttributeBoostingConfiguration.DateConfiguration).value

    /**
     * Casts this [DocumentAttributeBoostingConfiguration] as a [DateConfiguration] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration] value. Returns null if the [DocumentAttributeBoostingConfiguration] is not a [DateConfiguration].
     */
    public fun asDateConfigurationOrNull(): aws.sdk.kotlin.services.qbusiness.model.DateAttributeBoostingConfiguration? = (this as? DocumentAttributeBoostingConfiguration.DateConfiguration)?.value

    /**
     * Casts this [DocumentAttributeBoostingConfiguration] as a [NumberConfiguration] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration] value. Throws an exception if the [DocumentAttributeBoostingConfiguration] is not a
     * [NumberConfiguration].
     */
    public fun asNumberConfiguration(): aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration = (this as DocumentAttributeBoostingConfiguration.NumberConfiguration).value

    /**
     * Casts this [DocumentAttributeBoostingConfiguration] as a [NumberConfiguration] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration] value. Returns null if the [DocumentAttributeBoostingConfiguration] is not a [NumberConfiguration].
     */
    public fun asNumberConfigurationOrNull(): aws.sdk.kotlin.services.qbusiness.model.NumberAttributeBoostingConfiguration? = (this as? DocumentAttributeBoostingConfiguration.NumberConfiguration)?.value

    /**
     * Casts this [DocumentAttributeBoostingConfiguration] as a [StringConfiguration] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.StringAttributeBoostingConfiguration] value. Throws an exception if the [DocumentAttributeBoostingConfiguration] is not a
     * [StringConfiguration].
     */
    public fun asStringConfiguration(): aws.sdk.kotlin.services.qbusiness.model.StringAttributeBoostingConfiguration = (this as DocumentAttributeBoostingConfiguration.StringConfiguration).value

    /**
     * Casts this [DocumentAttributeBoostingConfiguration] as a [StringConfiguration] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.StringAttributeBoostingConfiguration] value. Returns null if the [DocumentAttributeBoostingConfiguration] is not a [StringConfiguration].
     */
    public fun asStringConfigurationOrNull(): aws.sdk.kotlin.services.qbusiness.model.StringAttributeBoostingConfiguration? = (this as? DocumentAttributeBoostingConfiguration.StringConfiguration)?.value

    /**
     * Casts this [DocumentAttributeBoostingConfiguration] as a [StringListConfiguration] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration] value. Throws an exception if the [DocumentAttributeBoostingConfiguration] is not a
     * [StringListConfiguration].
     */
    public fun asStringListConfiguration(): aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration = (this as DocumentAttributeBoostingConfiguration.StringListConfiguration).value

    /**
     * Casts this [DocumentAttributeBoostingConfiguration] as a [StringListConfiguration] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration] value. Returns null if the [DocumentAttributeBoostingConfiguration] is not a [StringListConfiguration].
     */
    public fun asStringListConfigurationOrNull(): aws.sdk.kotlin.services.qbusiness.model.StringListAttributeBoostingConfiguration? = (this as? DocumentAttributeBoostingConfiguration.StringListConfiguration)?.value
}
