// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A document in an Amazon Q Business application.
 */
public class Document private constructor(builder: Builder) {
    /**
     * Configuration information for access permission to a document.
     */
    public val accessConfiguration: aws.sdk.kotlin.services.qbusiness.model.AccessConfiguration? = builder.accessConfiguration
    /**
     * Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
     */
    public val attributes: List<DocumentAttribute>? = builder.attributes
    /**
     * The contents of the document.
     */
    public val content: aws.sdk.kotlin.services.qbusiness.model.DocumentContent? = builder.content
    /**
     * The file type of the document in the Blob field.
     *
     * If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents, you add the `HTML` start and closing tags (`&lt;HTML&gt;content&lt;/HTML&gt;`) around the content.
     */
    public val contentType: aws.sdk.kotlin.services.qbusiness.model.ContentType? = builder.contentType
    /**
     * The configuration information for altering document metadata and content during the document ingestion process.
     */
    public val documentEnrichmentConfiguration: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration? = builder.documentEnrichmentConfiguration
    /**
     * The identifier of the document.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The title of the document.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.Document = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Document(")
        append("accessConfiguration=$accessConfiguration,")
        append("attributes=$attributes,")
        append("content=$content,")
        append("contentType=$contentType,")
        append("documentEnrichmentConfiguration=$documentEnrichmentConfiguration,")
        append("id=$id,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessConfiguration?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (documentEnrichmentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Document

        if (accessConfiguration != other.accessConfiguration) return false
        if (attributes != other.attributes) return false
        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (documentEnrichmentConfiguration != other.documentEnrichmentConfiguration) return false
        if (id != other.id) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.Document = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configuration information for access permission to a document.
         */
        public var accessConfiguration: aws.sdk.kotlin.services.qbusiness.model.AccessConfiguration? = null
        /**
         * Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
         */
        public var attributes: List<DocumentAttribute>? = null
        /**
         * The contents of the document.
         */
        public var content: aws.sdk.kotlin.services.qbusiness.model.DocumentContent? = null
        /**
         * The file type of the document in the Blob field.
         *
         * If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents, you add the `HTML` start and closing tags (`&lt;HTML&gt;content&lt;/HTML&gt;`) around the content.
         */
        public var contentType: aws.sdk.kotlin.services.qbusiness.model.ContentType? = null
        /**
         * The configuration information for altering document metadata and content during the document ingestion process.
         */
        public var documentEnrichmentConfiguration: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration? = null
        /**
         * The identifier of the document.
         */
        public var id: kotlin.String? = null
        /**
         * The title of the document.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.Document) : this() {
            this.accessConfiguration = x.accessConfiguration
            this.attributes = x.attributes
            this.content = x.content
            this.contentType = x.contentType
            this.documentEnrichmentConfiguration = x.documentEnrichmentConfiguration
            this.id = x.id
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.Document = Document(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.AccessConfiguration] inside the given [block]
         */
        public fun accessConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.AccessConfiguration.Builder.() -> kotlin.Unit) {
            this.accessConfiguration = aws.sdk.kotlin.services.qbusiness.model.AccessConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration] inside the given [block]
         */
        public fun documentEnrichmentConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration.Builder.() -> kotlin.Unit) {
            this.documentEnrichmentConfiguration = aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            return this
        }
    }
}
