// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateIndexRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Q Business application using the index.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The capacity units you want to provision for your index. You can add and remove capacity to fit your usage needs.
     */
    public val capacityConfiguration: aws.sdk.kotlin.services.qbusiness.model.IndexCapacityConfiguration? = builder.capacityConfiguration
    /**
     * A token that you provide to identify the request to create an index. Multiple calls to the `CreateIndex` API with the same client token will create only one index.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the Amazon Q Business index.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A name for the Amazon Q Business index.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The index type that's suitable for your needs. For more information on what's included in each type of index or index tier, see [Amazon Q Business tiers](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/what-is.html#tiers).
     */
    public val type: aws.sdk.kotlin.services.qbusiness.model.IndexType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.CreateIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIndexRequest(")
        append("applicationId=$applicationId,")
        append("capacityConfiguration=$capacityConfiguration,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (capacityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIndexRequest

        if (applicationId != other.applicationId) return false
        if (capacityConfiguration != other.capacityConfiguration) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.CreateIndexRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Q Business application using the index.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The capacity units you want to provision for your index. You can add and remove capacity to fit your usage needs.
         */
        public var capacityConfiguration: aws.sdk.kotlin.services.qbusiness.model.IndexCapacityConfiguration? = null
        /**
         * A token that you provide to identify the request to create an index. Multiple calls to the `CreateIndex` API with the same client token will create only one index.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description for the Amazon Q Business index.
         */
        public var description: kotlin.String? = null
        /**
         * A name for the Amazon Q Business index.
         */
        public var displayName: kotlin.String? = null
        /**
         * A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         */
        public var tags: List<Tag>? = null
        /**
         * The index type that's suitable for your needs. For more information on what's included in each type of index or index tier, see [Amazon Q Business tiers](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/what-is.html#tiers).
         */
        public var type: aws.sdk.kotlin.services.qbusiness.model.IndexType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.CreateIndexRequest) : this() {
            this.applicationId = x.applicationId
            this.capacityConfiguration = x.capacityConfiguration
            this.clientToken = x.clientToken
            this.description = x.description
            this.displayName = x.displayName
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.CreateIndexRequest = CreateIndexRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.IndexCapacityConfiguration] inside the given [block]
         */
        public fun capacityConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.IndexCapacityConfiguration.Builder.() -> kotlin.Unit) {
            this.capacityConfiguration = aws.sdk.kotlin.services.qbusiness.model.IndexCapacityConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
