// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ChatSyncRequest private constructor(builder: Builder) {
    /**
     * A request from an end user to perform an Amazon Q Business plugin action.
     */
    public val actionExecution: aws.sdk.kotlin.services.qbusiness.model.ActionExecution? = builder.actionExecution
    /**
     * The identifier of the Amazon Q Business application linked to the Amazon Q Business conversation.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
     */
    public val attachments: List<AttachmentInput>? = builder.attachments
    /**
     * Enables filtering of Amazon Q Business web experience responses based on document attributes or metadata fields.
     */
    public val attributeFilter: aws.sdk.kotlin.services.qbusiness.model.AttributeFilter? = builder.attributeFilter
    /**
     * An authentication verification event response by a third party authentication server to Amazon Q Business.
     */
    public val authChallengeResponse: aws.sdk.kotlin.services.qbusiness.model.AuthChallengeResponse? = builder.authChallengeResponse
    /**
     * The chat modes available to an Amazon Q Business end user.
     * + `RETRIEVAL_MODE` - The default chat mode for an Amazon Q Business application. When this mode is enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q Business application.
     * + `CREATOR_MODE` - By selecting this mode, users can choose to generate responses only from the LLM knowledge, without consulting connected data sources, for a chat request.
     * + `PLUGIN_MODE` - By selecting this mode, users can choose to use plugins in chat.
     *
     * For more information, see [Admin controls and guardrails](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html), [Plugins](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html), and [Conversation settings](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
     */
    public val chatMode: aws.sdk.kotlin.services.qbusiness.model.ChatMode? = builder.chatMode
    /**
     * The chat mode configuration for an Amazon Q Business application.
     */
    public val chatModeConfiguration: aws.sdk.kotlin.services.qbusiness.model.ChatModeConfiguration? = builder.chatModeConfiguration
    /**
     * A token that you provide to identify a chat request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the Amazon Q Business conversation.
     */
    public val conversationId: kotlin.String? = builder.conversationId
    /**
     * The identifier of the previous end user text input message in a conversation.
     */
    public val parentMessageId: kotlin.String? = builder.parentMessageId
    /**
     * The groups that a user associated with the chat input belongs to.
     */
    public val userGroups: List<String>? = builder.userGroups
    /**
     * The identifier of the user attached to the chat input.
     */
    public val userId: kotlin.String? = builder.userId
    /**
     * A end user message in a conversation.
     */
    public val userMessage: kotlin.String? = builder.userMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.ChatSyncRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChatSyncRequest(")
        append("actionExecution=$actionExecution,")
        append("applicationId=$applicationId,")
        append("attachments=$attachments,")
        append("attributeFilter=$attributeFilter,")
        append("authChallengeResponse=$authChallengeResponse,")
        append("chatMode=$chatMode,")
        append("chatModeConfiguration=$chatModeConfiguration,")
        append("clientToken=$clientToken,")
        append("conversationId=$conversationId,")
        append("parentMessageId=$parentMessageId,")
        append("userGroups=$userGroups,")
        append("userId=$userId,")
        append("userMessage=$userMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionExecution?.hashCode() ?: 0
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (attachments?.hashCode() ?: 0)
        result = 31 * result + (attributeFilter?.hashCode() ?: 0)
        result = 31 * result + (authChallengeResponse?.hashCode() ?: 0)
        result = 31 * result + (chatMode?.hashCode() ?: 0)
        result = 31 * result + (chatModeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (conversationId?.hashCode() ?: 0)
        result = 31 * result + (parentMessageId?.hashCode() ?: 0)
        result = 31 * result + (userGroups?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (userMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChatSyncRequest

        if (actionExecution != other.actionExecution) return false
        if (applicationId != other.applicationId) return false
        if (attachments != other.attachments) return false
        if (attributeFilter != other.attributeFilter) return false
        if (authChallengeResponse != other.authChallengeResponse) return false
        if (chatMode != other.chatMode) return false
        if (chatModeConfiguration != other.chatModeConfiguration) return false
        if (clientToken != other.clientToken) return false
        if (conversationId != other.conversationId) return false
        if (parentMessageId != other.parentMessageId) return false
        if (userGroups != other.userGroups) return false
        if (userId != other.userId) return false
        if (userMessage != other.userMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.ChatSyncRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A request from an end user to perform an Amazon Q Business plugin action.
         */
        public var actionExecution: aws.sdk.kotlin.services.qbusiness.model.ActionExecution? = null
        /**
         * The identifier of the Amazon Q Business application linked to the Amazon Q Business conversation.
         */
        public var applicationId: kotlin.String? = null
        /**
         * A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
         */
        public var attachments: List<AttachmentInput>? = null
        /**
         * Enables filtering of Amazon Q Business web experience responses based on document attributes or metadata fields.
         */
        public var attributeFilter: aws.sdk.kotlin.services.qbusiness.model.AttributeFilter? = null
        /**
         * An authentication verification event response by a third party authentication server to Amazon Q Business.
         */
        public var authChallengeResponse: aws.sdk.kotlin.services.qbusiness.model.AuthChallengeResponse? = null
        /**
         * The chat modes available to an Amazon Q Business end user.
         * + `RETRIEVAL_MODE` - The default chat mode for an Amazon Q Business application. When this mode is enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q Business application.
         * + `CREATOR_MODE` - By selecting this mode, users can choose to generate responses only from the LLM knowledge, without consulting connected data sources, for a chat request.
         * + `PLUGIN_MODE` - By selecting this mode, users can choose to use plugins in chat.
         *
         * For more information, see [Admin controls and guardrails](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html), [Plugins](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html), and [Conversation settings](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
         */
        public var chatMode: aws.sdk.kotlin.services.qbusiness.model.ChatMode? = null
        /**
         * The chat mode configuration for an Amazon Q Business application.
         */
        public var chatModeConfiguration: aws.sdk.kotlin.services.qbusiness.model.ChatModeConfiguration? = null
        /**
         * A token that you provide to identify a chat request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the Amazon Q Business conversation.
         */
        public var conversationId: kotlin.String? = null
        /**
         * The identifier of the previous end user text input message in a conversation.
         */
        public var parentMessageId: kotlin.String? = null
        /**
         * The groups that a user associated with the chat input belongs to.
         */
        public var userGroups: List<String>? = null
        /**
         * The identifier of the user attached to the chat input.
         */
        public var userId: kotlin.String? = null
        /**
         * A end user message in a conversation.
         */
        public var userMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.ChatSyncRequest) : this() {
            this.actionExecution = x.actionExecution
            this.applicationId = x.applicationId
            this.attachments = x.attachments
            this.attributeFilter = x.attributeFilter
            this.authChallengeResponse = x.authChallengeResponse
            this.chatMode = x.chatMode
            this.chatModeConfiguration = x.chatModeConfiguration
            this.clientToken = x.clientToken
            this.conversationId = x.conversationId
            this.parentMessageId = x.parentMessageId
            this.userGroups = x.userGroups
            this.userId = x.userId
            this.userMessage = x.userMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.ChatSyncRequest = ChatSyncRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.ActionExecution] inside the given [block]
         */
        public fun actionExecution(block: aws.sdk.kotlin.services.qbusiness.model.ActionExecution.Builder.() -> kotlin.Unit) {
            this.actionExecution = aws.sdk.kotlin.services.qbusiness.model.ActionExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.AttributeFilter] inside the given [block]
         */
        public fun attributeFilter(block: aws.sdk.kotlin.services.qbusiness.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.attributeFilter = aws.sdk.kotlin.services.qbusiness.model.AttributeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.AuthChallengeResponse] inside the given [block]
         */
        public fun authChallengeResponse(block: aws.sdk.kotlin.services.qbusiness.model.AuthChallengeResponse.Builder.() -> kotlin.Unit) {
            this.authChallengeResponse = aws.sdk.kotlin.services.qbusiness.model.AuthChallengeResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
