// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.ActionExecution
import aws.sdk.kotlin.services.qbusiness.model.AttachmentInput
import aws.sdk.kotlin.services.qbusiness.model.AttributeFilter
import aws.sdk.kotlin.services.qbusiness.model.ChatSyncRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ChatSyncOperationSerializer: HttpSerialize<ChatSyncRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ChatSyncRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode("${input.applicationId}"))
                add(PercentEncoding.Path.encode("conversations"))
            }
            parameters.decodedParameters {
                add("sync", "")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.userGroups?.isNotEmpty() == true) addAll("userGroups", input.userGroups)
                if (input.userId != null) add("userId", input.userId)
            }
        }

        val payload = serializeChatSyncOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeChatSyncOperationBody(context: ExecutionContext, input: ChatSyncRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONEXECUTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("actionExecution"))
    val ATTACHMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("attachments"))
    val ATTRIBUTEFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("attributeFilter"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CONVERSATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("conversationId"))
    val PARENTMESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentMessageId"))
    val USERMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("userMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONEXECUTION_DESCRIPTOR)
        field(ATTACHMENTS_DESCRIPTOR)
        field(ATTRIBUTEFILTER_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONVERSATIONID_DESCRIPTOR)
        field(PARENTMESSAGEID_DESCRIPTOR)
        field(USERMESSAGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actionExecution?.let { field(ACTIONEXECUTION_DESCRIPTOR, it, ::serializeActionExecutionDocument) }
        if (input.attachments != null) {
            listField(ATTACHMENTS_DESCRIPTOR) {
                for (el0 in input.attachments) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAttachmentInputDocument))
                }
            }
        }
        input.attributeFilter?.let { field(ATTRIBUTEFILTER_DESCRIPTOR, it, ::serializeAttributeFilterDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.conversationId?.let { field(CONVERSATIONID_DESCRIPTOR, it) }
        input.parentMessageId?.let { field(PARENTMESSAGEID_DESCRIPTOR, it) }
        input.userMessage?.let { field(USERMESSAGE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
