// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * The topic specific controls configured for an Amazon Q application.
 */
public class TopicConfiguration private constructor(builder: Builder) {
    /**
     * A description for your topic control configuration. Use this to outline how the large language model (LLM) should use this topic control configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A list of example phrases that you expect the end user to use in relation to the topic.
     */
    public val exampleChatMessages: List<String>? = builder.exampleChatMessages
    /**
     * A name for your topic control configuration.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Rules defined for a topic configuration.
     */
    public val rules: List<Rule> = requireNotNull(builder.rules) { "A non-null value must be provided for rules" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.TopicConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicConfiguration(")
        append("description=$description,")
        append("exampleChatMessages=$exampleChatMessages,")
        append("name=$name,")
        append("rules=$rules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (exampleChatMessages?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (rules.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicConfiguration

        if (description != other.description) return false
        if (exampleChatMessages != other.exampleChatMessages) return false
        if (name != other.name) return false
        if (rules != other.rules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.TopicConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description for your topic control configuration. Use this to outline how the large language model (LLM) should use this topic control configuration.
         */
        public var description: kotlin.String? = null
        /**
         * A list of example phrases that you expect the end user to use in relation to the topic.
         */
        public var exampleChatMessages: List<String>? = null
        /**
         * A name for your topic control configuration.
         */
        public var name: kotlin.String? = null
        /**
         * Rules defined for a topic configuration.
         */
        public var rules: List<Rule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.TopicConfiguration) : this() {
            this.description = x.description
            this.exampleChatMessages = x.exampleChatMessages
            this.name = x.name
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.TopicConfiguration = TopicConfiguration(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (rules == null) rules = emptyList()
            return this
        }
    }
}
