// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * Provides the SAML 2.0 compliant identity provider (IdP) configuration information Amazon Q needs to deploy a Amazon Q web experience.
 */
public class SamlConfiguration private constructor(builder: Builder) {
    /**
     * The metadata XML that your IdP generated.
     */
    public val metadataXml: kotlin.String = requireNotNull(builder.metadataXml) { "A non-null value must be provided for metadataXml" }
    /**
     * The Amazon Resource Name (ARN) of an IAM role assumed by users when they authenticate into their Amazon Q web experience, containing the relevant Amazon Q permissions for conversing with Amazon Q.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The group attribute name in your IdP that maps to user groups.
     */
    public val userGroupAttribute: kotlin.String? = builder.userGroupAttribute
    /**
     * The user attribute name in your IdP that maps to the user email.
     */
    public val userIdAttribute: kotlin.String = requireNotNull(builder.userIdAttribute) { "A non-null value must be provided for userIdAttribute" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.SamlConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamlConfiguration(")
        append("metadataXml=$metadataXml,")
        append("roleArn=$roleArn,")
        append("userGroupAttribute=$userGroupAttribute,")
        append("userIdAttribute=$userIdAttribute")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metadataXml.hashCode()
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (userGroupAttribute?.hashCode() ?: 0)
        result = 31 * result + (userIdAttribute.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamlConfiguration

        if (metadataXml != other.metadataXml) return false
        if (roleArn != other.roleArn) return false
        if (userGroupAttribute != other.userGroupAttribute) return false
        if (userIdAttribute != other.userIdAttribute) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.SamlConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The metadata XML that your IdP generated.
         */
        public var metadataXml: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role assumed by users when they authenticate into their Amazon Q web experience, containing the relevant Amazon Q permissions for conversing with Amazon Q.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The group attribute name in your IdP that maps to user groups.
         */
        public var userGroupAttribute: kotlin.String? = null
        /**
         * The user attribute name in your IdP that maps to the user email.
         */
        public var userIdAttribute: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.SamlConfiguration) : this() {
            this.metadataXml = x.metadataXml
            this.roleArn = x.roleArn
            this.userGroupAttribute = x.userGroupAttribute
            this.userIdAttribute = x.userIdAttribute
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.SamlConfiguration = SamlConfiguration(this)

        internal fun correctErrors(): Builder {
            if (metadataXml == null) metadataXml = ""
            if (roleArn == null) roleArn = ""
            if (userIdAttribute == null) userIdAttribute = ""
            return this
        }
    }
}
