// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try again.
 */
public class ResourceNotFoundException private constructor(builder: Builder) : QBusinessException(builder.message) {

    /**
     * The identifier of the resource affected.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * The type of the resource affected.
     */
    public val resourceType: kotlin.String = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.ResourceNotFoundException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceNotFoundException(")
        append("message=$message,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (resourceId.hashCode())
        result = 31 * result + (resourceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceNotFoundException

        if (message != other.message) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.ResourceNotFoundException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The message describing a `ResourceNotFoundException`.
         */
        public var message: kotlin.String? = null
        /**
         * The identifier of the resource affected.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The type of the resource affected.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.ResourceNotFoundException) : this() {
            this.message = x.message
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.ResourceNotFoundException = ResourceNotFoundException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            if (resourceId == null) resourceId = ""
            if (resourceType == null) resourceType = ""
            return this
        }
    }
}
