// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * Provides the configuration information for altering document metadata and content during the document ingestion process.
 *
 * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
 */
public class DocumentEnrichmentConfiguration private constructor(builder: Builder) {
    /**
     * Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Q.
     */
    public val inlineConfigurations: List<InlineDocumentEnrichmentConfiguration>? = builder.inlineConfigurations
    /**
     * Provides the configuration information for invoking a Lambda function in Lambda to alter document metadata and content when ingesting documents into Amazon Q.
     *
     * You can configure your Lambda function using [PreExtractionHookConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html) if you want to apply advanced alterations on the original or raw documents.
     *
     * If you want to apply advanced alterations on the Amazon Q structured documents, you must configure your Lambda function using [PostExtractionHookConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html).
     *
     * You can only invoke one Lambda function. However, this function can invoke other functions it requires.
     *
     * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
     */
    public val postExtractionHookConfiguration: aws.sdk.kotlin.services.qbusiness.model.HookConfiguration? = builder.postExtractionHookConfiguration
    /**
     * Provides the configuration information for invoking a Lambda function in Lambda to alter document metadata and content when ingesting documents into Amazon Q.
     *
     * You can configure your Lambda function using [PreExtractionHookConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html) if you want to apply advanced alterations on the original or raw documents.
     *
     * If you want to apply advanced alterations on the Amazon Q structured documents, you must configure your Lambda function using [PostExtractionHookConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html).
     *
     * You can only invoke one Lambda function. However, this function can invoke other functions it requires.
     *
     * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
     */
    public val preExtractionHookConfiguration: aws.sdk.kotlin.services.qbusiness.model.HookConfiguration? = builder.preExtractionHookConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentEnrichmentConfiguration(")
        append("inlineConfigurations=$inlineConfigurations,")
        append("postExtractionHookConfiguration=$postExtractionHookConfiguration,")
        append("preExtractionHookConfiguration=$preExtractionHookConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inlineConfigurations?.hashCode() ?: 0
        result = 31 * result + (postExtractionHookConfiguration?.hashCode() ?: 0)
        result = 31 * result + (preExtractionHookConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentEnrichmentConfiguration

        if (inlineConfigurations != other.inlineConfigurations) return false
        if (postExtractionHookConfiguration != other.postExtractionHookConfiguration) return false
        if (preExtractionHookConfiguration != other.preExtractionHookConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Q.
         */
        public var inlineConfigurations: List<InlineDocumentEnrichmentConfiguration>? = null
        /**
         * Provides the configuration information for invoking a Lambda function in Lambda to alter document metadata and content when ingesting documents into Amazon Q.
         *
         * You can configure your Lambda function using [PreExtractionHookConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html) if you want to apply advanced alterations on the original or raw documents.
         *
         * If you want to apply advanced alterations on the Amazon Q structured documents, you must configure your Lambda function using [PostExtractionHookConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html).
         *
         * You can only invoke one Lambda function. However, this function can invoke other functions it requires.
         *
         * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
         */
        public var postExtractionHookConfiguration: aws.sdk.kotlin.services.qbusiness.model.HookConfiguration? = null
        /**
         * Provides the configuration information for invoking a Lambda function in Lambda to alter document metadata and content when ingesting documents into Amazon Q.
         *
         * You can configure your Lambda function using [PreExtractionHookConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html) if you want to apply advanced alterations on the original or raw documents.
         *
         * If you want to apply advanced alterations on the Amazon Q structured documents, you must configure your Lambda function using [PostExtractionHookConfiguration](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html).
         *
         * You can only invoke one Lambda function. However, this function can invoke other functions it requires.
         *
         * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
         */
        public var preExtractionHookConfiguration: aws.sdk.kotlin.services.qbusiness.model.HookConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration) : this() {
            this.inlineConfigurations = x.inlineConfigurations
            this.postExtractionHookConfiguration = x.postExtractionHookConfiguration
            this.preExtractionHookConfiguration = x.preExtractionHookConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration = DocumentEnrichmentConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.HookConfiguration] inside the given [block]
         */
        public fun postExtractionHookConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.HookConfiguration.Builder.() -> kotlin.Unit) {
            this.postExtractionHookConfiguration = aws.sdk.kotlin.services.qbusiness.model.HookConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.HookConfiguration] inside the given [block]
         */
        public fun preExtractionHookConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.HookConfiguration.Builder.() -> kotlin.Unit) {
            this.preExtractionHookConfiguration = aws.sdk.kotlin.services.qbusiness.model.HookConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
