// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * The contents of a document.
 */
public sealed class DocumentContent {
    /**
     * The contents of the document. Documents passed to the `blob` parameter must be base64 encoded. Your code might not need to encode the document file bytes if you're using an Amazon Web Services SDK to call Amazon Q APIs. If you are calling the Amazon Q endpoint directly using REST, you must base64 encode the contents before sending.
     */
    public data class Blob(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.qbusiness.model.DocumentContent() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as Blob

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }

    /**
     * The path to the document in an Amazon S3 bucket.
     */
    public data class S3(val value: aws.sdk.kotlin.services.qbusiness.model.S3) : aws.sdk.kotlin.services.qbusiness.model.DocumentContent() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.qbusiness.model.DocumentContent() {
    }

    /**
     * Casts this [DocumentContent] as a [Blob] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [DocumentContent] is not a
     * [Blob].
     */
    public fun asBlob(): kotlin.ByteArray = (this as DocumentContent.Blob).value

    /**
     * Casts this [DocumentContent] as a [Blob] and retrieves its [kotlin.ByteArray] value. Returns null if the [DocumentContent] is not a [Blob].
     */
    public fun asBlobOrNull(): kotlin.ByteArray? = (this as? DocumentContent.Blob)?.value

    /**
     * Casts this [DocumentContent] as a [S3] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.S3] value. Throws an exception if the [DocumentContent] is not a
     * [S3].
     */
    public fun asS3(): aws.sdk.kotlin.services.qbusiness.model.S3 = (this as DocumentContent.S3).value

    /**
     * Casts this [DocumentContent] as a [S3] and retrieves its [aws.sdk.kotlin.services.qbusiness.model.S3] value. Returns null if the [DocumentContent] is not a [S3].
     */
    public fun asS3OrNull(): aws.sdk.kotlin.services.qbusiness.model.S3? = (this as? DocumentContent.S3)?.value
}
