// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * The target document attribute or metadata field you want to alter when ingesting documents into Amazon Q.
 *
 * For example, you can delete all customer identification numbers associated with the documents, stored in the document metadata field called 'Customer_ID' by setting the target key as 'Customer_ID' and the deletion flag to `TRUE`. This removes all customer ID values in the field 'Customer_ID'. This would scrub personally identifiable information from each document's metadata.
 *
 * Amazon Q can't create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using `DocumentAttributeTarget`[](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html). Amazon Q will then map your newly created document attribute to your index field.
 *
 * You can also use this with `DocumentAttributeCondition`[](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeCondition.html).
 */
public class DocumentAttributeTarget private constructor(builder: Builder) {
    /**
     * `TRUE` to delete the existing target value for your specified target attribute key. You cannot create a target value and set this to `TRUE`.
     */
    public val attributeValueOperator: aws.sdk.kotlin.services.qbusiness.model.AttributeValueOperator? = builder.attributeValueOperator
    /**
     * The identifier of the target document attribute or metadata field. For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The value of a document attribute. You can only provide one value for a document attribute.
     */
    public val value: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeValue? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentAttributeTarget(")
        append("attributeValueOperator=$attributeValueOperator,")
        append("key=$key,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeValueOperator?.hashCode() ?: 0
        result = 31 * result + (key.hashCode())
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentAttributeTarget

        if (attributeValueOperator != other.attributeValueOperator) return false
        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * `TRUE` to delete the existing target value for your specified target attribute key. You cannot create a target value and set this to `TRUE`.
         */
        public var attributeValueOperator: aws.sdk.kotlin.services.qbusiness.model.AttributeValueOperator? = null
        /**
         * The identifier of the target document attribute or metadata field. For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
         */
        public var key: kotlin.String? = null
        /**
         * The value of a document attribute. You can only provide one value for a document attribute.
         */
        public var value: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget) : this() {
            this.attributeValueOperator = x.attributeValueOperator
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget = DocumentAttributeTarget(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            return this
        }
    }
}
