// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



public class DeleteGroupRequest private constructor(builder: Builder) {
    /**
     * The identifier of the application in which the group mapping belongs.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The identifier of the data source linked to the group
     *
     * A group can be tied to multiple data sources. You can delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * The name of the group you want to delete.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The identifier of the index you want to delete the group from.
     */
    public val indexId: kotlin.String? = builder.indexId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.DeleteGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteGroupRequest(")
        append("applicationId=$applicationId,")
        append("dataSourceId=$dataSourceId,")
        append("groupName=$groupName,")
        append("indexId=$indexId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteGroupRequest

        if (applicationId != other.applicationId) return false
        if (dataSourceId != other.dataSourceId) return false
        if (groupName != other.groupName) return false
        if (indexId != other.indexId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.DeleteGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the application in which the group mapping belongs.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The identifier of the data source linked to the group
         *
         * A group can be tied to multiple data sources. You can delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The name of the group you want to delete.
         */
        public var groupName: kotlin.String? = null
        /**
         * The identifier of the index you want to delete the group from.
         */
        public var indexId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.DeleteGroupRequest) : this() {
            this.applicationId = x.applicationId
            this.dataSourceId = x.dataSourceId
            this.groupName = x.groupName
            this.indexId = x.indexId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.DeleteGroupRequest = DeleteGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
