// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeConfiguration
import aws.sdk.kotlin.services.qbusiness.model.ErrorDetail
import aws.sdk.kotlin.services.qbusiness.model.GetIndexResponse
import aws.sdk.kotlin.services.qbusiness.model.IndexCapacityConfiguration
import aws.sdk.kotlin.services.qbusiness.model.IndexStatistics
import aws.sdk.kotlin.services.qbusiness.model.IndexStatus
import aws.sdk.kotlin.services.qbusiness.model.QBusinessException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetIndexOperationDeserializer: HttpDeserialize<GetIndexResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetIndexResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetIndexError(context, call)
        }
        val builder = GetIndexResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetIndexOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetIndexError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QBusinessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> QBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIndexOperationBody(builder: GetIndexResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val CAPACITYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("capacityConfiguration"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("displayName"))
    val DOCUMENTATTRIBUTECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("documentAttributeConfigurations"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("error"))
    val INDEXARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexArn"))
    val INDEXID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexId"))
    val INDEXSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("indexStatistics"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(CAPACITYCONFIGURATION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(DOCUMENTATTRIBUTECONFIGURATIONS_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(INDEXARN_DESCRIPTOR)
        field(INDEXID_DESCRIPTOR)
        field(INDEXSTATISTICS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                CAPACITYCONFIGURATION_DESCRIPTOR.index -> builder.capacityConfiguration = deserializeIndexCapacityConfigurationDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                DOCUMENTATTRIBUTECONFIGURATIONS_DESCRIPTOR.index -> builder.documentAttributeConfigurations =
                    deserializer.deserializeList(DOCUMENTATTRIBUTECONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentAttributeConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentAttributeConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERROR_DESCRIPTOR.index -> builder.error = deserializeErrorDetailDocument(deserializer)
                INDEXARN_DESCRIPTOR.index -> builder.indexArn = deserializeString()
                INDEXID_DESCRIPTOR.index -> builder.indexId = deserializeString()
                INDEXSTATISTICS_DESCRIPTOR.index -> builder.indexStatistics = deserializeIndexStatisticsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { IndexStatus.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
