// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * Provides the configuration information for applying basic logic to alter document metadata and content when ingesting documents into Amazon Q.
 *
 * To apply advanced logic, to go beyond what you can do with basic logic, see `HookConfiguration`[](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_HookConfiguration.html).
 *
 * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
 */
public class InlineDocumentEnrichmentConfiguration private constructor(builder: Builder) {
    /**
     * The condition used for the target document attribute or metadata field when ingesting documents into Amazon Q. You use this with `DocumentAttributeTarget`[](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_DocumentAttributeTarget.html) to apply the condition.
     *
     * For example, you can create the 'Department' target field and have it prefill department names associated with the documents based on information in the 'Source_URI' field. Set the condition that if the 'Source_URI' field contains 'financial' in its URI value, then prefill the target field 'Department' with the target value 'Finance' for the document.
     *
     * Amazon Q can't create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using `DocumentAttributeTarget`. Amazon Q then will map your newly created metadata field to your index field.
     */
    public val condition: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition? = builder.condition
    /**
     * `TRUE` to delete content if the condition used for the target attribute is met.
     */
    public val documentContentOperator: aws.sdk.kotlin.services.qbusiness.model.DocumentContentOperator? = builder.documentContentOperator
    /**
     * The target document attribute or metadata field you want to alter when ingesting documents into Amazon Q.
     *
     * For example, you can delete all customer identification numbers associated with the documents, stored in the document metadata field called 'Customer_ID' by setting the target key as 'Customer_ID' and the deletion flag to `TRUE`. This removes all customer ID values in the field 'Customer_ID'. This would scrub personally identifiable information from each document's metadata.
     *
     * Amazon Q can't create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using `DocumentAttributeTarget`[](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_DocumentAttributeTarget.html). Amazon Q will then map your newly created document attribute to your index field.
     *
     * You can also use this with `DocumentAttributeCondition`[](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_DocumentAttributeCondition.html).
     */
    public val target: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.InlineDocumentEnrichmentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InlineDocumentEnrichmentConfiguration(")
        append("condition=$condition,")
        append("documentContentOperator=$documentContentOperator,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (documentContentOperator?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InlineDocumentEnrichmentConfiguration

        if (condition != other.condition) return false
        if (documentContentOperator != other.documentContentOperator) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.InlineDocumentEnrichmentConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The condition used for the target document attribute or metadata field when ingesting documents into Amazon Q. You use this with `DocumentAttributeTarget`[](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_DocumentAttributeTarget.html) to apply the condition.
         *
         * For example, you can create the 'Department' target field and have it prefill department names associated with the documents based on information in the 'Source_URI' field. Set the condition that if the 'Source_URI' field contains 'financial' in its URI value, then prefill the target field 'Department' with the target value 'Finance' for the document.
         *
         * Amazon Q can't create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using `DocumentAttributeTarget`. Amazon Q then will map your newly created metadata field to your index field.
         */
        public var condition: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition? = null
        /**
         * `TRUE` to delete content if the condition used for the target attribute is met.
         */
        public var documentContentOperator: aws.sdk.kotlin.services.qbusiness.model.DocumentContentOperator? = null
        /**
         * The target document attribute or metadata field you want to alter when ingesting documents into Amazon Q.
         *
         * For example, you can delete all customer identification numbers associated with the documents, stored in the document metadata field called 'Customer_ID' by setting the target key as 'Customer_ID' and the deletion flag to `TRUE`. This removes all customer ID values in the field 'Customer_ID'. This would scrub personally identifiable information from each document's metadata.
         *
         * Amazon Q can't create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using `DocumentAttributeTarget`[](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_DocumentAttributeTarget.html). Amazon Q will then map your newly created document attribute to your index field.
         *
         * You can also use this with `DocumentAttributeCondition`[](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_DocumentAttributeCondition.html).
         */
        public var target: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.InlineDocumentEnrichmentConfiguration) : this() {
            this.condition = x.condition
            this.documentContentOperator = x.documentContentOperator
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.InlineDocumentEnrichmentConfiguration = InlineDocumentEnrichmentConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition] inside the given [block]
         */
        public fun condition(block: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition.Builder.() -> kotlin.Unit) {
            this.condition = aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget] inside the given [block]
         */
        public fun target(block: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget.Builder.() -> kotlin.Unit) {
            this.target = aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeTarget.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
