// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * Configuration information for document attributes. Document attributes are metadata or fields associated with your documents. For example, the company department name associated with each document.
 *
 * For more information, see [Understanding document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html).
 */
public class DocumentAttributeConfiguration private constructor(builder: Builder) {
    /**
     * The name of the document attribute.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Information about whether the document attribute can be used by an end user to search for information on their web experience.
     */
    public val search: aws.sdk.kotlin.services.qbusiness.model.Status? = builder.search
    /**
     * The type of document attribute.
     */
    public val type: aws.sdk.kotlin.services.qbusiness.model.AttributeType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentAttributeConfiguration(")
        append("name=$name,")
        append("search=$search,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (search?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentAttributeConfiguration

        if (name != other.name) return false
        if (search != other.search) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the document attribute.
         */
        public var name: kotlin.String? = null
        /**
         * Information about whether the document attribute can be used by an end user to search for information on their web experience.
         */
        public var search: aws.sdk.kotlin.services.qbusiness.model.Status? = null
        /**
         * The type of document attribute.
         */
        public var type: aws.sdk.kotlin.services.qbusiness.model.AttributeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeConfiguration) : this() {
            this.name = x.name
            this.search = x.search
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeConfiguration = DocumentAttributeConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
