// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * End user feedback on an AI-generated web experience chat message usefulness.
 */
public class MessageUsefulnessFeedback private constructor(builder: Builder) {
    /**
     * A comment given by an end user on the usefulness of an AI-generated chat message.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The reason for a usefulness rating.
     */
    public val reason: aws.sdk.kotlin.services.qbusiness.model.MessageUsefulnessReason? = builder.reason
    /**
     * The timestamp for when the feedback was submitted.
     */
    public val submittedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.submittedAt) { "A non-null value must be provided for submittedAt" }
    /**
     * The usefulness value assigned by an end user to a message.
     */
    public val usefulness: aws.sdk.kotlin.services.qbusiness.model.MessageUsefulness = requireNotNull(builder.usefulness) { "A non-null value must be provided for usefulness" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.MessageUsefulnessFeedback = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageUsefulnessFeedback(")
        append("comment=$comment,")
        append("reason=$reason,")
        append("submittedAt=$submittedAt,")
        append("usefulness=$usefulness")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (submittedAt.hashCode())
        result = 31 * result + (usefulness.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageUsefulnessFeedback

        if (comment != other.comment) return false
        if (reason != other.reason) return false
        if (submittedAt != other.submittedAt) return false
        if (usefulness != other.usefulness) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.MessageUsefulnessFeedback = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A comment given by an end user on the usefulness of an AI-generated chat message.
         */
        public var comment: kotlin.String? = null
        /**
         * The reason for a usefulness rating.
         */
        public var reason: aws.sdk.kotlin.services.qbusiness.model.MessageUsefulnessReason? = null
        /**
         * The timestamp for when the feedback was submitted.
         */
        public var submittedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The usefulness value assigned by an end user to a message.
         */
        public var usefulness: aws.sdk.kotlin.services.qbusiness.model.MessageUsefulness? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.MessageUsefulnessFeedback) : this() {
            this.comment = x.comment
            this.reason = x.reason
            this.submittedAt = x.submittedAt
            this.usefulness = x.usefulness
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.MessageUsefulnessFeedback = MessageUsefulnessFeedback(this)

        internal fun correctErrors(): Builder {
            if (submittedAt == null) submittedAt = Instant.fromEpochSeconds(0)
            if (usefulness == null) usefulness = MessageUsefulness.SdkUnknown("no value provided")
            return this
        }
    }
}
