// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model



/**
 * Provides the configuration information for invoking a Lambda function in Lambda to alter document metadata and content when ingesting documents into Amazon Q.
 *
 * You can configure your Lambda function using [PreExtractionHookConfiguration](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_CustomDocumentEnrichmentConfiguration.html) if you want to apply advanced alterations on the original or raw documents.
 *
 * If you want to apply advanced alterations on the Amazon Q structured documents, you must configure your Lambda function using [PostExtractionHookConfiguration](https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_CustomDocumentEnrichmentConfiguration.html).
 *
 * You can only invoke one Lambda function. However, this function can invoke other functions it requires.
 *
 * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
 */
public class HookConfiguration private constructor(builder: Builder) {
    /**
     * The condition used for when a Lambda function should be invoked.
     *
     * For example, you can specify a condition that if there are empty date-time values, then Amazon Q should invoke a function that inserts the current date-time.
     */
    public val invocationCondition: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition? = builder.invocationCondition
    /**
     * The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion. For more information, see [IAM roles for Custom Document Enrichment (CDE)](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/iam-roles.html#cde-iam-role).
     */
    public val lambdaArn: kotlin.String? = builder.lambdaArn
    /**
     * The Amazon Resource Name (ARN) of a role with permission to run `PreExtractionHookConfiguration` and `PostExtractionHookConfiguration` for altering document metadata and content during the document ingestion process.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts).
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.HookConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HookConfiguration(")
        append("invocationCondition=$invocationCondition,")
        append("lambdaArn=$lambdaArn,")
        append("roleArn=$roleArn,")
        append("s3BucketName=$s3BucketName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = invocationCondition?.hashCode() ?: 0
        result = 31 * result + (lambdaArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HookConfiguration

        if (invocationCondition != other.invocationCondition) return false
        if (lambdaArn != other.lambdaArn) return false
        if (roleArn != other.roleArn) return false
        if (s3BucketName != other.s3BucketName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.HookConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The condition used for when a Lambda function should be invoked.
         *
         * For example, you can specify a condition that if there are empty date-time values, then Amazon Q should invoke a function that inserts the current date-time.
         */
        public var invocationCondition: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition? = null
        /**
         * The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion. For more information, see [IAM roles for Custom Document Enrichment (CDE)](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/iam-roles.html#cde-iam-role).
         */
        public var lambdaArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a role with permission to run `PreExtractionHookConfiguration` and `PostExtractionHookConfiguration` for altering document metadata and content during the document ingestion process.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts).
         */
        public var s3BucketName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.HookConfiguration) : this() {
            this.invocationCondition = x.invocationCondition
            this.lambdaArn = x.lambdaArn
            this.roleArn = x.roleArn
            this.s3BucketName = x.s3BucketName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.HookConfiguration = HookConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition] inside the given [block]
         */
        public fun invocationCondition(block: aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition.Builder.() -> kotlin.Unit) {
            this.invocationCondition = aws.sdk.kotlin.services.qbusiness.model.DocumentAttributeCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
