// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.serde

import aws.sdk.kotlin.services.qapps.model.AppDefinition
import aws.sdk.kotlin.services.qapps.model.AppRequiredCapability
import aws.sdk.kotlin.services.qapps.model.AppStatus
import aws.sdk.kotlin.services.qapps.model.GetQAppResponse
import aws.sdk.kotlin.services.qapps.model.QAppsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetQAppOperationDeserializer: HttpDeserializer.NonStreaming<GetQAppResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetQAppResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetQAppError(context, call, payload)
        }
        val builder = GetQAppResponse.Builder()

        if (payload != null) {
            deserializeGetQAppOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetQAppError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QAppsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QAppsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQAppOperationBody(builder: GetQAppResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appArn"))
    val APPDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("appDefinition"))
    val APPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appId"))
    val APPVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("appVersion"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INITIALPROMPT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("initialPrompt"))
    val REQUIREDCAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("requiredCapabilities"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("title"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val UPDATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("updatedBy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPARN_DESCRIPTOR)
        field(APPDEFINITION_DESCRIPTOR)
        field(APPID_DESCRIPTOR)
        field(APPVERSION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INITIALPROMPT_DESCRIPTOR)
        field(REQUIREDCAPABILITIES_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(UPDATEDBY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPARN_DESCRIPTOR.index -> builder.appArn = deserializeString()
                APPDEFINITION_DESCRIPTOR.index -> builder.appDefinition = deserializeAppDefinitionDocument(deserializer)
                APPID_DESCRIPTOR.index -> builder.appId = deserializeString()
                APPVERSION_DESCRIPTOR.index -> builder.appVersion = deserializeInt()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INITIALPROMPT_DESCRIPTOR.index -> builder.initialPrompt = deserializeString()
                REQUIREDCAPABILITIES_DESCRIPTOR.index -> builder.requiredCapabilities =
                    deserializer.deserializeList(REQUIREDCAPABILITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AppRequiredCapability>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { AppRequiredCapability.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AppStatus.fromValue(it) }
                TITLE_DESCRIPTOR.index -> builder.title = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeInstant(TimestampFormat.ISO_8601)
                UPDATEDBY_DESCRIPTOR.index -> builder.updatedBy = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
