// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.serde

import aws.sdk.kotlin.services.qapps.model.Category
import aws.sdk.kotlin.services.qapps.model.GetLibraryItemResponse
import aws.sdk.kotlin.services.qapps.model.QAppsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetLibraryItemOperationDeserializer: HttpDeserializer.NonStreaming<GetLibraryItemResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetLibraryItemResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetLibraryItemError(context, call, payload)
        }
        val builder = GetLibraryItemResponse.Builder()

        if (payload != null) {
            deserializeGetLibraryItemOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetLibraryItemError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QAppsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QAppsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLibraryItemOperationBody(builder: GetLibraryItemResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appId"))
    val APPVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("appVersion"))
    val CATEGORIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("categories"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val ISRATEDBYUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isRatedByUser"))
    val ISVERIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isVerified"))
    val LIBRARYITEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("libraryItemId"))
    val RATINGCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ratingCount"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val UPDATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("updatedBy"))
    val USERCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("userCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPID_DESCRIPTOR)
        field(APPVERSION_DESCRIPTOR)
        field(CATEGORIES_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(ISRATEDBYUSER_DESCRIPTOR)
        field(ISVERIFIED_DESCRIPTOR)
        field(LIBRARYITEMID_DESCRIPTOR)
        field(RATINGCOUNT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(UPDATEDBY_DESCRIPTOR)
        field(USERCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPID_DESCRIPTOR.index -> builder.appId = deserializeString()
                APPVERSION_DESCRIPTOR.index -> builder.appVersion = deserializeInt()
                CATEGORIES_DESCRIPTOR.index -> builder.categories =
                    deserializer.deserializeList(CATEGORIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Category>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCategoryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                ISRATEDBYUSER_DESCRIPTOR.index -> builder.isRatedByUser = deserializeBoolean()
                ISVERIFIED_DESCRIPTOR.index -> builder.isVerified = deserializeBoolean()
                LIBRARYITEMID_DESCRIPTOR.index -> builder.libraryItemId = deserializeString()
                RATINGCOUNT_DESCRIPTOR.index -> builder.ratingCount = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeInstant(TimestampFormat.ISO_8601)
                UPDATEDBY_DESCRIPTOR.index -> builder.updatedBy = deserializeString()
                USERCOUNT_DESCRIPTOR.index -> builder.userCount = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
