// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.serde

import aws.sdk.kotlin.services.qapps.model.CreatePresignedUrlResponse
import aws.sdk.kotlin.services.qapps.model.QAppsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class CreatePresignedUrlOperationDeserializer: HttpDeserializer.NonStreaming<CreatePresignedUrlResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreatePresignedUrlResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreatePresignedUrlError(context, call, payload)
        }
        val builder = CreatePresignedUrlResponse.Builder()

        if (payload != null) {
            deserializeCreatePresignedUrlOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreatePresignedUrlError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QAppsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QAppsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePresignedUrlOperationBody(builder: CreatePresignedUrlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("fileId"))
    val PRESIGNEDURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("presignedUrl"))
    val PRESIGNEDURLEXPIRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("presignedUrlExpiration"))
    val PRESIGNEDURLFIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("presignedUrlFields"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILEID_DESCRIPTOR)
        field(PRESIGNEDURL_DESCRIPTOR)
        field(PRESIGNEDURLEXPIRATION_DESCRIPTOR)
        field(PRESIGNEDURLFIELDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FILEID_DESCRIPTOR.index -> builder.fileId = deserializeString()
                PRESIGNEDURL_DESCRIPTOR.index -> builder.presignedUrl = deserializeString()
                PRESIGNEDURLEXPIRATION_DESCRIPTOR.index -> builder.presignedUrlExpiration = deserializeInstant(TimestampFormat.ISO_8601)
                PRESIGNEDURLFIELDS_DESCRIPTOR.index -> builder.presignedUrlFields =
                    deserializer.deserializeMap(PRESIGNEDURLFIELDS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
