// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdateQAppResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the updated Q App.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * The unique identifier of the updated Q App.
     */
    public val appId: kotlin.String = requireNotNull(builder.appId) { "A non-null value must be provided for appId" }
    /**
     * The new version of the updated Q App.
     */
    public val appVersion: kotlin.Int = requireNotNull(builder.appVersion) { "A non-null value must be provided for appVersion" }
    /**
     * The date and time the Q App was originally created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The user who originally created the Q App.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The new description of the updated Q App.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The initial prompt for the updated Q App.
     */
    public val initialPrompt: kotlin.String? = builder.initialPrompt
    /**
     * The capabilities required for the updated Q App.
     */
    public val requiredCapabilities: List<AppRequiredCapability>? = builder.requiredCapabilities
    /**
     * The status of the updated Q App.
     */
    public val status: aws.sdk.kotlin.services.qapps.model.AppStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The new title of the updated Q App.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }
    /**
     * The date and time the Q App was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The user who last updated the Q App.
     */
    public val updatedBy: kotlin.String = requireNotNull(builder.updatedBy) { "A non-null value must be provided for updatedBy" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.UpdateQAppResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateQAppResponse(")
        append("appArn=$appArn,")
        append("appId=$appId,")
        append("appVersion=$appVersion,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("initialPrompt=$initialPrompt,")
        append("requiredCapabilities=$requiredCapabilities,")
        append("status=$status,")
        append("title=$title,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appId.hashCode())
        result = 31 * result + (appVersion)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (initialPrompt?.hashCode() ?: 0)
        result = 31 * result + (requiredCapabilities?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (title.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (updatedBy.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateQAppResponse

        if (appArn != other.appArn) return false
        if (appId != other.appId) return false
        if (appVersion != other.appVersion) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (initialPrompt != other.initialPrompt) return false
        if (requiredCapabilities != other.requiredCapabilities) return false
        if (status != other.status) return false
        if (title != other.title) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.UpdateQAppResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the updated Q App.
         */
        public var appArn: kotlin.String? = null
        /**
         * The unique identifier of the updated Q App.
         */
        public var appId: kotlin.String? = null
        /**
         * The new version of the updated Q App.
         */
        public var appVersion: kotlin.Int? = null
        /**
         * The date and time the Q App was originally created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who originally created the Q App.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The new description of the updated Q App.
         */
        public var description: kotlin.String? = null
        /**
         * The initial prompt for the updated Q App.
         */
        public var initialPrompt: kotlin.String? = null
        /**
         * The capabilities required for the updated Q App.
         */
        public var requiredCapabilities: List<AppRequiredCapability>? = null
        /**
         * The status of the updated Q App.
         */
        public var status: aws.sdk.kotlin.services.qapps.model.AppStatus? = null
        /**
         * The new title of the updated Q App.
         */
        public var title: kotlin.String? = null
        /**
         * The date and time the Q App was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who last updated the Q App.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.UpdateQAppResponse) : this() {
            this.appArn = x.appArn
            this.appId = x.appId
            this.appVersion = x.appVersion
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.initialPrompt = x.initialPrompt
            this.requiredCapabilities = x.requiredCapabilities
            this.status = x.status
            this.title = x.title
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.UpdateQAppResponse = UpdateQAppResponse(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appId == null) appId = ""
            if (appVersion == null) appVersion = 0
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (status == null) status = AppStatus.SdkUnknown("no value provided")
            if (title == null) title = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            if (updatedBy == null) updatedBy = ""
            return this
        }
    }
}
