// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The sharing configuration of an Amazon Q App data collection session.
 */
public class SessionSharingConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether an Q App session can accept responses from users.
     */
    public val acceptResponses: kotlin.Boolean? = builder.acceptResponses
    /**
     * Indicates whether an Q App session is shareable with other users.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * Indicates whether collected responses for an Q App session are revealed for all users.
     */
    public val revealCards: kotlin.Boolean? = builder.revealCards

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.SessionSharingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionSharingConfiguration(")
        append("acceptResponses=$acceptResponses,")
        append("enabled=$enabled,")
        append("revealCards=$revealCards")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptResponses?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (revealCards?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionSharingConfiguration

        if (acceptResponses != other.acceptResponses) return false
        if (enabled != other.enabled) return false
        if (revealCards != other.revealCards) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.SessionSharingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether an Q App session can accept responses from users.
         */
        public var acceptResponses: kotlin.Boolean? = null
        /**
         * Indicates whether an Q App session is shareable with other users.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Indicates whether collected responses for an Q App session are revealed for all users.
         */
        public var revealCards: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.SessionSharingConfiguration) : this() {
            this.acceptResponses = x.acceptResponses
            this.enabled = x.enabled
            this.revealCards = x.revealCards
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.SessionSharingConfiguration = SessionSharingConfiguration(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            return this
        }
    }
}
