// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.content.Document
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The response collected for a Amazon Q App session. This container represents a single response to a Q App session.
 */
public class QAppSessionData private constructor(builder: Builder) {
    /**
     * The card Id associated with the response submitted for a Q App session.
     */
    public val cardId: kotlin.String = requireNotNull(builder.cardId) { "A non-null value must be provided for cardId" }
    /**
     * The unique identifier of the submission.
     */
    public val submissionId: kotlin.String? = builder.submissionId
    /**
     * The date and time when the session data is submitted.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The user who submitted the response for a Q App session.
     */
    public val user: aws.sdk.kotlin.services.qapps.model.User? = builder.user
    /**
     * The response submitted for a Q App session.
     */
    public val value: aws.smithy.kotlin.runtime.content.Document? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.QAppSessionData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QAppSessionData(")
        append("cardId=$cardId,")
        append("submissionId=$submissionId,")
        append("timestamp=$timestamp,")
        append("user=$user,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cardId.hashCode()
        result = 31 * result + (submissionId?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QAppSessionData

        if (cardId != other.cardId) return false
        if (submissionId != other.submissionId) return false
        if (timestamp != other.timestamp) return false
        if (user != other.user) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.QAppSessionData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The card Id associated with the response submitted for a Q App session.
         */
        public var cardId: kotlin.String? = null
        /**
         * The unique identifier of the submission.
         */
        public var submissionId: kotlin.String? = null
        /**
         * The date and time when the session data is submitted.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who submitted the response for a Q App session.
         */
        public var user: aws.sdk.kotlin.services.qapps.model.User? = null
        /**
         * The response submitted for a Q App session.
         */
        public var value: aws.smithy.kotlin.runtime.content.Document? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.QAppSessionData) : this() {
            this.cardId = x.cardId
            this.submissionId = x.submissionId
            this.timestamp = x.timestamp
            this.user = x.user
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.QAppSessionData = QAppSessionData(this)

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.User] inside the given [block]
         */
        public fun user(block: aws.sdk.kotlin.services.qapps.model.User.Builder.() -> kotlin.Unit) {
            this.user = aws.sdk.kotlin.services.qapps.model.User.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (cardId == null) cardId = ""
            return this
        }
    }
}
