// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetQAppSessionResponse private constructor(builder: Builder) {
    /**
     * The version of the Q App used for the session.
     */
    public val appVersion: kotlin.Int? = builder.appVersion
    /**
     * The current status for each card in the Q App session.
     */
    public val cardStatus: Map<String, CardStatus> = requireNotNull(builder.cardStatus) { "A non-null value must be provided for cardStatus" }
    /**
     * The latest published version of the Q App used for the session.
     */
    public val latestPublishedAppVersion: kotlin.Int? = builder.latestPublishedAppVersion
    /**
     * The Amazon Resource Name (ARN) of the Q App session.
     */
    public val sessionArn: kotlin.String = requireNotNull(builder.sessionArn) { "A non-null value must be provided for sessionArn" }
    /**
     * The unique identifier of the Q App session.
     */
    public val sessionId: kotlin.String = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * The name of the Q App session.
     */
    public val sessionName: kotlin.String? = builder.sessionName
    /**
     * The current status of the Q App session.
     */
    public val status: aws.sdk.kotlin.services.qapps.model.ExecutionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Indicates whether the current user is the owner of the Q App data collection session.
     */
    public val userIsHost: kotlin.Boolean? = builder.userIsHost

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.GetQAppSessionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetQAppSessionResponse(")
        append("appVersion=$appVersion,")
        append("cardStatus=$cardStatus,")
        append("latestPublishedAppVersion=$latestPublishedAppVersion,")
        append("sessionArn=$sessionArn,")
        append("sessionId=$sessionId,")
        append("sessionName=$sessionName,")
        append("status=$status,")
        append("userIsHost=$userIsHost")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appVersion ?: 0
        result = 31 * result + (cardStatus.hashCode())
        result = 31 * result + (latestPublishedAppVersion ?: 0)
        result = 31 * result + (sessionArn.hashCode())
        result = 31 * result + (sessionId.hashCode())
        result = 31 * result + (sessionName?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (userIsHost?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetQAppSessionResponse

        if (appVersion != other.appVersion) return false
        if (cardStatus != other.cardStatus) return false
        if (latestPublishedAppVersion != other.latestPublishedAppVersion) return false
        if (sessionArn != other.sessionArn) return false
        if (sessionId != other.sessionId) return false
        if (sessionName != other.sessionName) return false
        if (status != other.status) return false
        if (userIsHost != other.userIsHost) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.GetQAppSessionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The version of the Q App used for the session.
         */
        public var appVersion: kotlin.Int? = null
        /**
         * The current status for each card in the Q App session.
         */
        public var cardStatus: Map<String, CardStatus>? = null
        /**
         * The latest published version of the Q App used for the session.
         */
        public var latestPublishedAppVersion: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the Q App session.
         */
        public var sessionArn: kotlin.String? = null
        /**
         * The unique identifier of the Q App session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The name of the Q App session.
         */
        public var sessionName: kotlin.String? = null
        /**
         * The current status of the Q App session.
         */
        public var status: aws.sdk.kotlin.services.qapps.model.ExecutionStatus? = null
        /**
         * Indicates whether the current user is the owner of the Q App data collection session.
         */
        public var userIsHost: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.GetQAppSessionResponse) : this() {
            this.appVersion = x.appVersion
            this.cardStatus = x.cardStatus
            this.latestPublishedAppVersion = x.latestPublishedAppVersion
            this.sessionArn = x.sessionArn
            this.sessionId = x.sessionId
            this.sessionName = x.sessionName
            this.status = x.status
            this.userIsHost = x.userIsHost
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.GetQAppSessionResponse = GetQAppSessionResponse(this)

        internal fun correctErrors(): Builder {
            if (cardStatus == null) cardStatus = emptyMap()
            if (sessionArn == null) sessionArn = ""
            if (sessionId == null) sessionId = ""
            if (status == null) status = ExecutionStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
