// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetQAppResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Q App.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * The full definition of the Q App, specifying the cards and flow.
     */
    public val appDefinition: aws.sdk.kotlin.services.qapps.model.AppDefinition? = builder.appDefinition
    /**
     * The unique identifier of the Q App.
     */
    public val appId: kotlin.String = requireNotNull(builder.appId) { "A non-null value must be provided for appId" }
    /**
     * The version of the Q App.
     */
    public val appVersion: kotlin.Int = requireNotNull(builder.appVersion) { "A non-null value must be provided for appVersion" }
    /**
     * The date and time the Q App was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The user who created the Q App.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The description of the Q App.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The initial prompt displayed when the Q App is started.
     */
    public val initialPrompt: kotlin.String? = builder.initialPrompt
    /**
     * The capabilities required to run the Q App, such as file upload or third-party integrations.
     */
    public val requiredCapabilities: List<AppRequiredCapability>? = builder.requiredCapabilities
    /**
     * The status of the Q App.
     */
    public val status: aws.sdk.kotlin.services.qapps.model.AppStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The title of the Q App.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }
    /**
     * The date and time the Q App was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The user who last updated the Q App.
     */
    public val updatedBy: kotlin.String = requireNotNull(builder.updatedBy) { "A non-null value must be provided for updatedBy" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.GetQAppResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetQAppResponse(")
        append("appArn=$appArn,")
        append("appDefinition=$appDefinition,")
        append("appId=$appId,")
        append("appVersion=$appVersion,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("initialPrompt=$initialPrompt,")
        append("requiredCapabilities=$requiredCapabilities,")
        append("status=$status,")
        append("title=$title,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appDefinition?.hashCode() ?: 0)
        result = 31 * result + (appId.hashCode())
        result = 31 * result + (appVersion)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (initialPrompt?.hashCode() ?: 0)
        result = 31 * result + (requiredCapabilities?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (title.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (updatedBy.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetQAppResponse

        if (appArn != other.appArn) return false
        if (appDefinition != other.appDefinition) return false
        if (appId != other.appId) return false
        if (appVersion != other.appVersion) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (initialPrompt != other.initialPrompt) return false
        if (requiredCapabilities != other.requiredCapabilities) return false
        if (status != other.status) return false
        if (title != other.title) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.GetQAppResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Q App.
         */
        public var appArn: kotlin.String? = null
        /**
         * The full definition of the Q App, specifying the cards and flow.
         */
        public var appDefinition: aws.sdk.kotlin.services.qapps.model.AppDefinition? = null
        /**
         * The unique identifier of the Q App.
         */
        public var appId: kotlin.String? = null
        /**
         * The version of the Q App.
         */
        public var appVersion: kotlin.Int? = null
        /**
         * The date and time the Q App was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who created the Q App.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of the Q App.
         */
        public var description: kotlin.String? = null
        /**
         * The initial prompt displayed when the Q App is started.
         */
        public var initialPrompt: kotlin.String? = null
        /**
         * The capabilities required to run the Q App, such as file upload or third-party integrations.
         */
        public var requiredCapabilities: List<AppRequiredCapability>? = null
        /**
         * The status of the Q App.
         */
        public var status: aws.sdk.kotlin.services.qapps.model.AppStatus? = null
        /**
         * The title of the Q App.
         */
        public var title: kotlin.String? = null
        /**
         * The date and time the Q App was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who last updated the Q App.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.GetQAppResponse) : this() {
            this.appArn = x.appArn
            this.appDefinition = x.appDefinition
            this.appId = x.appId
            this.appVersion = x.appVersion
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.initialPrompt = x.initialPrompt
            this.requiredCapabilities = x.requiredCapabilities
            this.status = x.status
            this.title = x.title
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.GetQAppResponse = GetQAppResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.AppDefinition] inside the given [block]
         */
        public fun appDefinition(block: aws.sdk.kotlin.services.qapps.model.AppDefinition.Builder.() -> kotlin.Unit) {
            this.appDefinition = aws.sdk.kotlin.services.qapps.model.AppDefinition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appId == null) appId = ""
            if (appVersion == null) appVersion = 0
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (status == null) status = AppStatus.SdkUnknown("no value provided")
            if (title == null) title = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            if (updatedBy == null) updatedBy = ""
            return this
        }
    }
}
