// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetLibraryItemResponse private constructor(builder: Builder) {
    /**
     * The unique identifier of the Q App associated with the library item.
     */
    public val appId: kotlin.String = requireNotNull(builder.appId) { "A non-null value must be provided for appId" }
    /**
     * The version of the Q App associated with the library item.
     */
    public val appVersion: kotlin.Int = requireNotNull(builder.appVersion) { "A non-null value must be provided for appVersion" }
    /**
     * The categories associated with the library item for discovery.
     */
    public val categories: List<Category> = requireNotNull(builder.categories) { "A non-null value must be provided for categories" }
    /**
     * The date and time the library item was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The user who created the library item.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * Whether the current user has rated the library item.
     */
    public val isRatedByUser: kotlin.Boolean? = builder.isRatedByUser
    /**
     * Indicates whether the library item has been verified.
     */
    public val isVerified: kotlin.Boolean? = builder.isVerified
    /**
     * The unique identifier of the library item.
     */
    public val libraryItemId: kotlin.String = requireNotNull(builder.libraryItemId) { "A non-null value must be provided for libraryItemId" }
    /**
     * The number of ratings the library item has received from users.
     */
    public val ratingCount: kotlin.Int = requireNotNull(builder.ratingCount) { "A non-null value must be provided for ratingCount" }
    /**
     * The status of the library item, such as "Published".
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The date and time the library item was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The user who last updated the library item.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy
    /**
     * The number of users who have associated the Q App with their account.
     */
    public val userCount: kotlin.Int? = builder.userCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.GetLibraryItemResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetLibraryItemResponse(")
        append("appId=$appId,")
        append("appVersion=$appVersion,")
        append("categories=$categories,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("isRatedByUser=$isRatedByUser,")
        append("isVerified=$isVerified,")
        append("libraryItemId=$libraryItemId,")
        append("ratingCount=$ratingCount,")
        append("status=$status,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy,")
        append("userCount=$userCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId.hashCode()
        result = 31 * result + (appVersion)
        result = 31 * result + (categories.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (isRatedByUser?.hashCode() ?: 0)
        result = 31 * result + (isVerified?.hashCode() ?: 0)
        result = 31 * result + (libraryItemId.hashCode())
        result = 31 * result + (ratingCount)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        result = 31 * result + (userCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetLibraryItemResponse

        if (appId != other.appId) return false
        if (appVersion != other.appVersion) return false
        if (categories != other.categories) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (isRatedByUser != other.isRatedByUser) return false
        if (isVerified != other.isVerified) return false
        if (libraryItemId != other.libraryItemId) return false
        if (ratingCount != other.ratingCount) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false
        if (userCount != other.userCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.GetLibraryItemResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the Q App associated with the library item.
         */
        public var appId: kotlin.String? = null
        /**
         * The version of the Q App associated with the library item.
         */
        public var appVersion: kotlin.Int? = null
        /**
         * The categories associated with the library item for discovery.
         */
        public var categories: List<Category>? = null
        /**
         * The date and time the library item was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who created the library item.
         */
        public var createdBy: kotlin.String? = null
        /**
         * Whether the current user has rated the library item.
         */
        public var isRatedByUser: kotlin.Boolean? = null
        /**
         * Indicates whether the library item has been verified.
         */
        public var isVerified: kotlin.Boolean? = null
        /**
         * The unique identifier of the library item.
         */
        public var libraryItemId: kotlin.String? = null
        /**
         * The number of ratings the library item has received from users.
         */
        public var ratingCount: kotlin.Int? = null
        /**
         * The status of the library item, such as "Published".
         */
        public var status: kotlin.String? = null
        /**
         * The date and time the library item was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who last updated the library item.
         */
        public var updatedBy: kotlin.String? = null
        /**
         * The number of users who have associated the Q App with their account.
         */
        public var userCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.GetLibraryItemResponse) : this() {
            this.appId = x.appId
            this.appVersion = x.appVersion
            this.categories = x.categories
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.isRatedByUser = x.isRatedByUser
            this.isVerified = x.isVerified
            this.libraryItemId = x.libraryItemId
            this.ratingCount = x.ratingCount
            this.status = x.status
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
            this.userCount = x.userCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.GetLibraryItemResponse = GetLibraryItemResponse(this)

        internal fun correctErrors(): Builder {
            if (appId == null) appId = ""
            if (appVersion == null) appVersion = 0
            if (categories == null) categories = emptyList()
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (libraryItemId == null) libraryItemId = ""
            if (ratingCount == null) ratingCount = 0
            if (status == null) status = ""
            return this
        }
    }
}
