// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a form input card for an Amazon Q App.
 */
public class FormInputCardInput private constructor(builder: Builder) {
    /**
     * The compute mode of the form input card. This property determines whether individual participants of a data collection session can submit multiple response or one response. A compute mode of `append` shall allow participants to submit the same form multiple times with different values. A compute mode of `replace`code> shall overwrite the current value for each participant.
     */
    public val computeMode: aws.sdk.kotlin.services.qapps.model.InputCardComputeMode? = builder.computeMode
    /**
     * The unique identifier of the form input card.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The metadata that defines the form input card data.
     */
    public val metadata: aws.sdk.kotlin.services.qapps.model.FormInputCardMetadata? = builder.metadata
    /**
     * The title or label of the form input card.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }
    /**
     * The type of the card.
     */
    public val type: aws.sdk.kotlin.services.qapps.model.CardType = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.FormInputCardInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FormInputCardInput(")
        append("computeMode=$computeMode,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("title=$title,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeMode?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (title.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FormInputCardInput

        if (computeMode != other.computeMode) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (title != other.title) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.FormInputCardInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The compute mode of the form input card. This property determines whether individual participants of a data collection session can submit multiple response or one response. A compute mode of `append` shall allow participants to submit the same form multiple times with different values. A compute mode of `replace`code> shall overwrite the current value for each participant.
         */
        public var computeMode: aws.sdk.kotlin.services.qapps.model.InputCardComputeMode? = null
        /**
         * The unique identifier of the form input card.
         */
        public var id: kotlin.String? = null
        /**
         * The metadata that defines the form input card data.
         */
        public var metadata: aws.sdk.kotlin.services.qapps.model.FormInputCardMetadata? = null
        /**
         * The title or label of the form input card.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the card.
         */
        public var type: aws.sdk.kotlin.services.qapps.model.CardType = aws.sdk.kotlin.services.qapps.model.CardType.fromValue("form-input")

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.FormInputCardInput) : this() {
            this.computeMode = x.computeMode
            this.id = x.id
            this.metadata = x.metadata
            this.title = x.title
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.FormInputCardInput = FormInputCardInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.FormInputCardMetadata] inside the given [block]
         */
        public fun metadata(block: aws.sdk.kotlin.services.qapps.model.FormInputCardMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.qapps.model.FormInputCardMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (title == null) title = ""
            return this
        }
    }
}
