// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a file upload card. It can optionally receive a `filename` and `fileId` to set a default file. If not received, the user must provide the file when the Q App runs.
 */
public class FileUploadCardInput private constructor(builder: Builder) {
    /**
     * A flag indicating if the user can override the default file for the upload card.
     */
    public val allowOverride: kotlin.Boolean? = builder.allowOverride
    /**
     * The identifier of a pre-uploaded file associated with the card.
     */
    public val fileId: kotlin.String? = builder.fileId
    /**
     * The default filename to use for the file upload card.
     */
    public val filename: kotlin.String? = builder.filename
    /**
     * The unique identifier of the file upload card.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The title or label of the file upload card.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }
    /**
     * The type of the card.
     */
    public val type: aws.sdk.kotlin.services.qapps.model.CardType = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.FileUploadCardInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileUploadCardInput(")
        append("allowOverride=$allowOverride,")
        append("fileId=$fileId,")
        append("filename=$filename,")
        append("id=$id,")
        append("title=$title,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowOverride?.hashCode() ?: 0
        result = 31 * result + (fileId?.hashCode() ?: 0)
        result = 31 * result + (filename?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (title.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileUploadCardInput

        if (allowOverride != other.allowOverride) return false
        if (fileId != other.fileId) return false
        if (filename != other.filename) return false
        if (id != other.id) return false
        if (title != other.title) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.FileUploadCardInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag indicating if the user can override the default file for the upload card.
         */
        public var allowOverride: kotlin.Boolean? = null
        /**
         * The identifier of a pre-uploaded file associated with the card.
         */
        public var fileId: kotlin.String? = null
        /**
         * The default filename to use for the file upload card.
         */
        public var filename: kotlin.String? = null
        /**
         * The unique identifier of the file upload card.
         */
        public var id: kotlin.String? = null
        /**
         * The title or label of the file upload card.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the card.
         */
        public var type: aws.sdk.kotlin.services.qapps.model.CardType = aws.sdk.kotlin.services.qapps.model.CardType.fromValue("file-upload")

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.FileUploadCardInput) : this() {
            this.allowOverride = x.allowOverride
            this.fileId = x.fileId
            this.filename = x.filename
            this.id = x.id
            this.title = x.title
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.FileUploadCardInput = FileUploadCardInput(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (title == null) title = ""
            return this
        }
    }
}
