// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A card in an Amazon Q App that allows the user to upload a file.
 */
public class FileUploadCard private constructor(builder: Builder) {
    /**
     * A flag indicating if the user can override the default file for the upload card.
     */
    public val allowOverride: kotlin.Boolean? = builder.allowOverride
    /**
     * Any dependencies or requirements for the file upload card.
     */
    public val dependencies: List<String> = requireNotNull(builder.dependencies) { "A non-null value must be provided for dependencies" }
    /**
     * The unique identifier of the file associated with the card.
     */
    public val fileId: kotlin.String? = builder.fileId
    /**
     * The name of the file being uploaded.
     */
    public val filename: kotlin.String? = builder.filename
    /**
     * The unique identifier of the file upload card.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The title of the file upload card.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }
    /**
     * The type of the card.
     */
    public val type: aws.sdk.kotlin.services.qapps.model.CardType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.FileUploadCard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileUploadCard(")
        append("allowOverride=$allowOverride,")
        append("dependencies=$dependencies,")
        append("fileId=$fileId,")
        append("filename=$filename,")
        append("id=$id,")
        append("title=$title,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowOverride?.hashCode() ?: 0
        result = 31 * result + (dependencies.hashCode())
        result = 31 * result + (fileId?.hashCode() ?: 0)
        result = 31 * result + (filename?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (title.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileUploadCard

        if (allowOverride != other.allowOverride) return false
        if (dependencies != other.dependencies) return false
        if (fileId != other.fileId) return false
        if (filename != other.filename) return false
        if (id != other.id) return false
        if (title != other.title) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.FileUploadCard = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag indicating if the user can override the default file for the upload card.
         */
        public var allowOverride: kotlin.Boolean? = null
        /**
         * Any dependencies or requirements for the file upload card.
         */
        public var dependencies: List<String>? = null
        /**
         * The unique identifier of the file associated with the card.
         */
        public var fileId: kotlin.String? = null
        /**
         * The name of the file being uploaded.
         */
        public var filename: kotlin.String? = null
        /**
         * The unique identifier of the file upload card.
         */
        public var id: kotlin.String? = null
        /**
         * The title of the file upload card.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the card.
         */
        public var type: aws.sdk.kotlin.services.qapps.model.CardType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.FileUploadCard) : this() {
            this.allowOverride = x.allowOverride
            this.dependencies = x.dependencies
            this.fileId = x.fileId
            this.filename = x.filename
            this.id = x.id
            this.title = x.title
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.FileUploadCard = FileUploadCard(this)

        internal fun correctErrors(): Builder {
            if (dependencies == null) dependencies = emptyList()
            if (id == null) id = ""
            if (title == null) title = ""
            if (type == null) type = CardType.SdkUnknown("no value provided")
            return this
        }
    }
}
