// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ExportQAppSessionDataResponse private constructor(builder: Builder) {
    /**
     * The link where the exported Q App session data can be downloaded from.
     */
    public val csvFileLink: kotlin.String = requireNotNull(builder.csvFileLink) { "A non-null value must be provided for csvFileLink" }
    /**
     * The date and time when the link for the exported Q App session data expires.
     */
    public val expiresAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.expiresAt) { "A non-null value must be provided for expiresAt" }
    /**
     * The Amazon Resource Name (ARN) of the Q App data collection session.
     */
    public val sessionArn: kotlin.String = requireNotNull(builder.sessionArn) { "A non-null value must be provided for sessionArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.ExportQAppSessionDataResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportQAppSessionDataResponse(")
        append("csvFileLink=$csvFileLink,")
        append("expiresAt=$expiresAt,")
        append("sessionArn=$sessionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = csvFileLink.hashCode()
        result = 31 * result + (expiresAt.hashCode())
        result = 31 * result + (sessionArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportQAppSessionDataResponse

        if (csvFileLink != other.csvFileLink) return false
        if (expiresAt != other.expiresAt) return false
        if (sessionArn != other.sessionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.ExportQAppSessionDataResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The link where the exported Q App session data can be downloaded from.
         */
        public var csvFileLink: kotlin.String? = null
        /**
         * The date and time when the link for the exported Q App session data expires.
         */
        public var expiresAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the Q App data collection session.
         */
        public var sessionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.ExportQAppSessionDataResponse) : this() {
            this.csvFileLink = x.csvFileLink
            this.expiresAt = x.expiresAt
            this.sessionArn = x.sessionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.ExportQAppSessionDataResponse = ExportQAppSessionDataResponse(this)

        internal fun correctErrors(): Builder {
            if (csvFileLink == null) csvFileLink = ""
            if (expiresAt == null) expiresAt = Instant.fromEpochSeconds(0)
            if (sessionArn == null) sessionArn = ""
            return this
        }
    }
}
