// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The value or result associated with a card in a Amazon Q App session.
 */
public class CardValue private constructor(builder: Builder) {
    /**
     * The unique identifier of the card.
     */
    public val cardId: kotlin.String = requireNotNull(builder.cardId) { "A non-null value must be provided for cardId" }
    /**
     * The structure that describes how the current form card value is mutated. Only applies for form cards when multiple responses are allowed.
     */
    public val submissionMutation: aws.sdk.kotlin.services.qapps.model.SubmissionMutation? = builder.submissionMutation
    /**
     * The value or result associated with the card.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.CardValue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CardValue(")
        append("cardId=$cardId,")
        append("submissionMutation=$submissionMutation,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cardId.hashCode()
        result = 31 * result + (submissionMutation?.hashCode() ?: 0)
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CardValue

        if (cardId != other.cardId) return false
        if (submissionMutation != other.submissionMutation) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.CardValue = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the card.
         */
        public var cardId: kotlin.String? = null
        /**
         * The structure that describes how the current form card value is mutated. Only applies for form cards when multiple responses are allowed.
         */
        public var submissionMutation: aws.sdk.kotlin.services.qapps.model.SubmissionMutation? = null
        /**
         * The value or result associated with the card.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.CardValue) : this() {
            this.cardId = x.cardId
            this.submissionMutation = x.submissionMutation
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.CardValue = CardValue(this)

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.SubmissionMutation] inside the given [block]
         */
        public fun submissionMutation(block: aws.sdk.kotlin.services.qapps.model.SubmissionMutation.Builder.() -> kotlin.Unit) {
            this.submissionMutation = aws.sdk.kotlin.services.qapps.model.SubmissionMutation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (cardId == null) cardId = ""
            if (value == null) value = ""
            return this
        }
    }
}
