// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The definition of the Q App, specifying the cards and flow.
 */
public class AppDefinition private constructor(builder: Builder) {
    /**
     * The version of the app definition schema or specification.
     */
    public val appDefinitionVersion: kotlin.String = requireNotNull(builder.appDefinitionVersion) { "A non-null value must be provided for appDefinitionVersion" }
    /**
     * A flag indicating whether the Q App's definition can be edited by the user.
     */
    public val canEdit: kotlin.Boolean? = builder.canEdit
    /**
     * The cards that make up the Q App, such as text input, file upload, or query cards.
     */
    public val cards: List<Card> = requireNotNull(builder.cards) { "A non-null value must be provided for cards" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.AppDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppDefinition(")
        append("appDefinitionVersion=$appDefinitionVersion,")
        append("canEdit=$canEdit,")
        append("cards=$cards")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appDefinitionVersion.hashCode()
        result = 31 * result + (canEdit?.hashCode() ?: 0)
        result = 31 * result + (cards.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppDefinition

        if (appDefinitionVersion != other.appDefinitionVersion) return false
        if (canEdit != other.canEdit) return false
        if (cards != other.cards) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.AppDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The version of the app definition schema or specification.
         */
        public var appDefinitionVersion: kotlin.String? = null
        /**
         * A flag indicating whether the Q App's definition can be edited by the user.
         */
        public var canEdit: kotlin.Boolean? = null
        /**
         * The cards that make up the Q App, such as text input, file upload, or query cards.
         */
        public var cards: List<Card>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.AppDefinition) : this() {
            this.appDefinitionVersion = x.appDefinitionVersion
            this.canEdit = x.canEdit
            this.cards = x.cards
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.AppDefinition = AppDefinition(this)

        internal fun correctErrors(): Builder {
            if (appDefinitionVersion == null) appDefinitionVersion = ""
            if (cards == null) cards = emptyList()
            return this
        }
    }
}
