// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.qapps.auth.QAppsAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.qapps.auth.QAppsIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.qapps.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.qapps.model.*
import aws.sdk.kotlin.services.qapps.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultQAppsClient(override val config: QAppsClient.Config) : QAppsClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = QAppsIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "qapps")
        }
        toMap()
    }
    private val authSchemeAdapter = QAppsAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.qapps"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates a rating or review for a library item with the user submitting the request. This increments the rating count for the specified library item.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.AssociateLibraryItemReview.sample
     */
    override suspend fun associateLibraryItemReview(input: AssociateLibraryItemReviewRequest): AssociateLibraryItemReviewResponse {
        val op = SdkHttpOperation.build<AssociateLibraryItemReviewRequest, AssociateLibraryItemReviewResponse> {
            serializeWith = AssociateLibraryItemReviewOperationSerializer()
            deserializeWith = AssociateLibraryItemReviewOperationDeserializer()
            operationName = "AssociateLibraryItemReview"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This operation creates a link between the user's identity calling the operation and a specific Q App. This is useful to mark the Q App as a *favorite* for the user if the user doesn't own the Amazon Q App so they can still run it and see it in their inventory of Q Apps.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.AssociateQAppWithUser.sample
     */
    override suspend fun associateQAppWithUser(input: AssociateQAppWithUserRequest): AssociateQAppWithUserResponse {
        val op = SdkHttpOperation.build<AssociateQAppWithUserRequest, AssociateQAppWithUserResponse> {
            serializeWith = AssociateQAppWithUserOperationSerializer()
            deserializeWith = AssociateQAppWithUserOperationDeserializer()
            operationName = "AssociateQAppWithUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates Categories for the Amazon Q Business application environment instance. Web experience users use Categories to tag and filter library items. For more information, see [Custom labels for Amazon Q Apps](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html).
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.BatchCreateCategory.sample
     */
    override suspend fun batchCreateCategory(input: BatchCreateCategoryRequest): BatchCreateCategoryResponse {
        val op = SdkHttpOperation.build<BatchCreateCategoryRequest, BatchCreateCategoryResponse> {
            serializeWith = BatchCreateCategoryOperationSerializer()
            deserializeWith = BatchCreateCategoryOperationDeserializer()
            operationName = "BatchCreateCategory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes Categories for the Amazon Q Business application environment instance. Web experience users use Categories to tag and filter library items. For more information, see [Custom labels for Amazon Q Apps](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html).
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.BatchDeleteCategory.sample
     */
    override suspend fun batchDeleteCategory(input: BatchDeleteCategoryRequest): BatchDeleteCategoryResponse {
        val op = SdkHttpOperation.build<BatchDeleteCategoryRequest, BatchDeleteCategoryResponse> {
            serializeWith = BatchDeleteCategoryOperationSerializer()
            deserializeWith = BatchDeleteCategoryOperationDeserializer()
            operationName = "BatchDeleteCategory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates Categories for the Amazon Q Business application environment instance. Web experience users use Categories to tag and filter library items. For more information, see [Custom labels for Amazon Q Apps](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html).
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.BatchUpdateCategory.sample
     */
    override suspend fun batchUpdateCategory(input: BatchUpdateCategoryRequest): BatchUpdateCategoryResponse {
        val op = SdkHttpOperation.build<BatchUpdateCategoryRequest, BatchUpdateCategoryResponse> {
            serializeWith = BatchUpdateCategoryOperationSerializer()
            deserializeWith = BatchUpdateCategoryOperationDeserializer()
            operationName = "BatchUpdateCategory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new library item for an Amazon Q App, allowing it to be discovered and used by other allowed users.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.CreateLibraryItem.sample
     */
    override suspend fun createLibraryItem(input: CreateLibraryItemRequest): CreateLibraryItemResponse {
        val op = SdkHttpOperation.build<CreateLibraryItemRequest, CreateLibraryItemResponse> {
            serializeWith = CreateLibraryItemOperationSerializer()
            deserializeWith = CreateLibraryItemOperationDeserializer()
            operationName = "CreateLibraryItem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a presigned URL for an S3 POST operation to upload a file. You can use this URL to set a default file for a `FileUploadCard` in a Q App definition or to provide a file for a single Q App run. The `scope` parameter determines how the file will be used, either at the app definition level or the app session level.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.CreatePresignedUrl.sample
     * @sample aws.sdk.kotlin.services.qapps.samples.CreatePresignedUrl.sample2
     */
    override suspend fun createPresignedUrl(input: CreatePresignedUrlRequest): CreatePresignedUrlResponse {
        val op = SdkHttpOperation.build<CreatePresignedUrlRequest, CreatePresignedUrlResponse> {
            serializeWith = CreatePresignedUrlOperationSerializer()
            deserializeWith = CreatePresignedUrlOperationDeserializer()
            operationName = "CreatePresignedUrl"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon Q App based on the provided definition. The Q App definition specifies the cards and flow of the Q App. This operation also calculates the dependencies between the cards by inspecting the references in the prompts.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.CreateQApp.sample
     */
    override suspend fun createQApp(input: CreateQAppRequest): CreateQAppResponse {
        val op = SdkHttpOperation.build<CreateQAppRequest, CreateQAppResponse> {
            serializeWith = CreateQAppOperationSerializer()
            deserializeWith = CreateQAppOperationDeserializer()
            operationName = "CreateQApp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a library item for an Amazon Q App, removing it from the library so it can no longer be discovered or used by other users.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DeleteLibraryItem.sample
     */
    override suspend fun deleteLibraryItem(input: DeleteLibraryItemRequest): DeleteLibraryItemResponse {
        val op = SdkHttpOperation.build<DeleteLibraryItemRequest, DeleteLibraryItemResponse> {
            serializeWith = DeleteLibraryItemOperationSerializer()
            deserializeWith = DeleteLibraryItemOperationDeserializer()
            operationName = "DeleteLibraryItem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Q App owned by the user. If the Q App was previously published to the library, it is also removed from the library.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DeleteQApp.sample
     */
    override suspend fun deleteQApp(input: DeleteQAppRequest): DeleteQAppResponse {
        val op = SdkHttpOperation.build<DeleteQAppRequest, DeleteQAppResponse> {
            serializeWith = DeleteQAppOperationSerializer()
            deserializeWith = DeleteQAppOperationDeserializer()
            operationName = "DeleteQApp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DescribeQAppPermissions.sample
     */
    override suspend fun describeQAppPermissions(input: DescribeQAppPermissionsRequest): DescribeQAppPermissionsResponse {
        val op = SdkHttpOperation.build<DescribeQAppPermissionsRequest, DescribeQAppPermissionsResponse> {
            serializeWith = DescribeQAppPermissionsOperationSerializer()
            deserializeWith = DescribeQAppPermissionsOperationDeserializer()
            operationName = "DescribeQAppPermissions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a rating or review previously submitted by the user for a library item.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DisassociateLibraryItemReview.sample
     */
    override suspend fun disassociateLibraryItemReview(input: DisassociateLibraryItemReviewRequest): DisassociateLibraryItemReviewResponse {
        val op = SdkHttpOperation.build<DisassociateLibraryItemReviewRequest, DisassociateLibraryItemReviewResponse> {
            serializeWith = DisassociateLibraryItemReviewOperationSerializer()
            deserializeWith = DisassociateLibraryItemReviewOperationDeserializer()
            operationName = "DisassociateLibraryItemReview"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a Q App from a user removing the user's access to run the Q App.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DisassociateQAppFromUser.sample
     */
    override suspend fun disassociateQAppFromUser(input: DisassociateQAppFromUserRequest): DisassociateQAppFromUserResponse {
        val op = SdkHttpOperation.build<DisassociateQAppFromUserRequest, DisassociateQAppFromUserResponse> {
            serializeWith = DisassociateQAppFromUserOperationSerializer()
            deserializeWith = DisassociateQAppFromUserOperationDeserializer()
            operationName = "DisassociateQAppFromUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Exports the collected data of a Q App data collection session.
     */
    override suspend fun exportQAppSessionData(input: ExportQAppSessionDataRequest): ExportQAppSessionDataResponse {
        val op = SdkHttpOperation.build<ExportQAppSessionDataRequest, ExportQAppSessionDataResponse> {
            serializeWith = ExportQAppSessionDataOperationSerializer()
            deserializeWith = ExportQAppSessionDataOperationDeserializer()
            operationName = "ExportQAppSessionData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details about a library item for an Amazon Q App, including its metadata, categories, ratings, and usage statistics.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.GetLibraryItem.sample
     */
    override suspend fun getLibraryItem(input: GetLibraryItemRequest): GetLibraryItemResponse {
        val op = SdkHttpOperation.build<GetLibraryItemRequest, GetLibraryItemResponse> {
            serializeWith = GetLibraryItemOperationSerializer()
            deserializeWith = GetLibraryItemOperationDeserializer()
            operationName = "GetLibraryItem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the full details of an Q App, including its definition specifying the cards and flow.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.GetQApp.sample
     */
    override suspend fun getQApp(input: GetQAppRequest): GetQAppResponse {
        val op = SdkHttpOperation.build<GetQAppRequest, GetQAppResponse> {
            serializeWith = GetQAppOperationSerializer()
            deserializeWith = GetQAppOperationDeserializer()
            operationName = "GetQApp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current state and results for an active session of an Amazon Q App.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.GetQAppSession.sample
     */
    override suspend fun getQAppSession(input: GetQAppSessionRequest): GetQAppSessionResponse {
        val op = SdkHttpOperation.build<GetQAppSessionRequest, GetQAppSessionResponse> {
            serializeWith = GetQAppSessionOperationSerializer()
            deserializeWith = GetQAppSessionOperationDeserializer()
            operationName = "GetQAppSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current configuration of a Q App session.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.GetQAppSessionMetadata.sample
     */
    override suspend fun getQAppSessionMetadata(input: GetQAppSessionMetadataRequest): GetQAppSessionMetadataResponse {
        val op = SdkHttpOperation.build<GetQAppSessionMetadataRequest, GetQAppSessionMetadataResponse> {
            serializeWith = GetQAppSessionMetadataOperationSerializer()
            deserializeWith = GetQAppSessionMetadataOperationDeserializer()
            operationName = "GetQAppSessionMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Uploads a file that can then be used either as a default in a `FileUploadCard` from Q App definition or as a file that is used inside a single Q App run. The purpose of the document is determined by a scope parameter that indicates whether it is at the app definition level or at the app session level.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ImportDocument.sample
     * @sample aws.sdk.kotlin.services.qapps.samples.ImportDocument.sample2
     */
    override suspend fun importDocument(input: ImportDocumentRequest): ImportDocumentResponse {
        val op = SdkHttpOperation.build<ImportDocumentRequest, ImportDocumentResponse> {
            serializeWith = ImportDocumentOperationSerializer()
            deserializeWith = ImportDocumentOperationDeserializer()
            operationName = "ImportDocument"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the categories of a Amazon Q Business application environment instance. For more information, see [Custom labels for Amazon Q Apps](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html).
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ListCategories.sample
     */
    override suspend fun listCategories(input: ListCategoriesRequest): ListCategoriesResponse {
        val op = SdkHttpOperation.build<ListCategoriesRequest, ListCategoriesResponse> {
            serializeWith = ListCategoriesOperationSerializer()
            deserializeWith = ListCategoriesOperationDeserializer()
            operationName = "ListCategories"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the library items for Amazon Q Apps that are published and available for users in your Amazon Web Services account.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ListLibraryItems.sample
     */
    override suspend fun listLibraryItems(input: ListLibraryItemsRequest): ListLibraryItemsResponse {
        val op = SdkHttpOperation.build<ListLibraryItemsRequest, ListLibraryItemsResponse> {
            serializeWith = ListLibraryItemsOperationSerializer()
            deserializeWith = ListLibraryItemsOperationDeserializer()
            operationName = "ListLibraryItems"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the collected data of a Q App data collection session.
     */
    override suspend fun listQAppSessionData(input: ListQAppSessionDataRequest): ListQAppSessionDataResponse {
        val op = SdkHttpOperation.build<ListQAppSessionDataRequest, ListQAppSessionDataResponse> {
            serializeWith = ListQAppSessionDataOperationSerializer()
            deserializeWith = ListQAppSessionDataOperationDeserializer()
            operationName = "ListQAppSessionData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Q Apps owned by or associated with the user either because they created it or because they used it from the library in the past. The user identity is extracted from the credentials used to invoke this operation..
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ListQApps.sample
     * @sample aws.sdk.kotlin.services.qapps.samples.ListQApps.sample2
     */
    override suspend fun listQApps(input: ListQAppsRequest): ListQAppsResponse {
        val op = SdkHttpOperation.build<ListQAppsRequest, ListQAppsResponse> {
            serializeWith = ListQAppsOperationSerializer()
            deserializeWith = ListQAppsOperationDeserializer()
            operationName = "ListQApps"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags associated with an Amazon Q Apps resource.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ListTagsForResource.sample
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Generates an Amazon Q App definition based on either a conversation or a problem statement provided as input.The resulting app definition can be used to call `CreateQApp`. This API doesn't create Amazon Q Apps directly.
     */
    override suspend fun predictQApp(input: PredictQAppRequest): PredictQAppResponse {
        val op = SdkHttpOperation.build<PredictQAppRequest, PredictQAppResponse> {
            serializeWith = PredictQAppOperationSerializer()
            deserializeWith = PredictQAppOperationDeserializer()
            operationName = "PredictQApp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a new session for an Amazon Q App, allowing inputs to be provided and the app to be run.
     *
     * Each Q App session will be condensed into a single conversation in the web experience.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.StartQAppSession.sample
     */
    override suspend fun startQAppSession(input: StartQAppSessionRequest): StartQAppSessionResponse {
        val op = SdkHttpOperation.build<StartQAppSessionRequest, StartQAppSessionResponse> {
            serializeWith = StartQAppSessionOperationSerializer()
            deserializeWith = StartQAppSessionOperationDeserializer()
            operationName = "StartQAppSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops an active session for an Amazon Q App.This deletes all data related to the session and makes it invalid for future uses. The results of the session will be persisted as part of the conversation.
     */
    override suspend fun stopQAppSession(input: StopQAppSessionRequest): StopQAppSessionResponse {
        val op = SdkHttpOperation.build<StopQAppSessionRequest, StopQAppSessionResponse> {
            serializeWith = StopQAppSessionOperationSerializer()
            deserializeWith = StopQAppSessionOperationDeserializer()
            operationName = "StopQAppSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates tags with an Amazon Q Apps resource.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.TagResource.sample
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates tags from an Amazon Q Apps resource.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UntagResource.sample
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the library item for an Amazon Q App.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateLibraryItem.sample
     */
    override suspend fun updateLibraryItem(input: UpdateLibraryItemRequest): UpdateLibraryItemResponse {
        val op = SdkHttpOperation.build<UpdateLibraryItemRequest, UpdateLibraryItemResponse> {
            serializeWith = UpdateLibraryItemOperationSerializer()
            deserializeWith = UpdateLibraryItemOperationDeserializer()
            operationName = "UpdateLibraryItem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the verification status of a library item for an Amazon Q App.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateLibraryItemMetadata.sample
     */
    override suspend fun updateLibraryItemMetadata(input: UpdateLibraryItemMetadataRequest): UpdateLibraryItemMetadataResponse {
        val op = SdkHttpOperation.build<UpdateLibraryItemMetadataRequest, UpdateLibraryItemMetadataResponse> {
            serializeWith = UpdateLibraryItemMetadataOperationSerializer()
            deserializeWith = UpdateLibraryItemMetadataOperationDeserializer()
            operationName = "UpdateLibraryItemMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Amazon Q App, allowing modifications to its title, description, and definition.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQApp.sample
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQApp.sample2
     */
    override suspend fun updateQApp(input: UpdateQAppRequest): UpdateQAppResponse {
        val op = SdkHttpOperation.build<UpdateQAppRequest, UpdateQAppResponse> {
            serializeWith = UpdateQAppOperationSerializer()
            deserializeWith = UpdateQAppOperationDeserializer()
            operationName = "UpdateQApp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQAppPermissions.sample
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQAppPermissions.sample2
     */
    override suspend fun updateQAppPermissions(input: UpdateQAppPermissionsRequest): UpdateQAppPermissionsResponse {
        val op = SdkHttpOperation.build<UpdateQAppPermissionsRequest, UpdateQAppPermissionsResponse> {
            serializeWith = UpdateQAppPermissionsOperationSerializer()
            deserializeWith = UpdateQAppPermissionsOperationDeserializer()
            operationName = "UpdateQAppPermissions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the session for a given Q App `sessionId`. This is only valid when at least one card of the session is in the `WAITING` state. Data for each `WAITING` card can be provided as input. If inputs are not provided, the call will be accepted but session will not move forward. Inputs for cards that are not in the `WAITING` status will be ignored.
     */
    override suspend fun updateQAppSession(input: UpdateQAppSessionRequest): UpdateQAppSessionResponse {
        val op = SdkHttpOperation.build<UpdateQAppSessionRequest, UpdateQAppSessionResponse> {
            serializeWith = UpdateQAppSessionOperationSerializer()
            deserializeWith = UpdateQAppSessionOperationDeserializer()
            operationName = "UpdateQAppSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration metadata of a session for a given Q App `sessionId`.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQAppSessionMetadata.sample
     */
    override suspend fun updateQAppSessionMetadata(input: UpdateQAppSessionMetadataRequest): UpdateQAppSessionMetadataResponse {
        val op = SdkHttpOperation.build<UpdateQAppSessionMetadataRequest, UpdateQAppSessionMetadataResponse> {
            serializeWith = UpdateQAppSessionMetadataOperationSerializer()
            deserializeWith = UpdateQAppSessionMetadataOperationDeserializer()
            operationName = "UpdateQAppSessionMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "qapps")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
