// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.paginators

import aws.sdk.kotlin.services.qapps.QAppsClient
import aws.sdk.kotlin.services.qapps.model.LibraryItemMember
import aws.sdk.kotlin.services.qapps.model.ListLibraryItemsRequest
import aws.sdk.kotlin.services.qapps.model.ListLibraryItemsResponse
import aws.sdk.kotlin.services.qapps.model.ListQAppsRequest
import aws.sdk.kotlin.services.qapps.model.ListQAppsResponse
import aws.sdk.kotlin.services.qapps.model.UserAppItem
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListLibraryItemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLibraryItemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLibraryItemsResponse]
 */
public fun QAppsClient.listLibraryItemsPaginated(initialRequest: ListLibraryItemsRequest): Flow<ListLibraryItemsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLibraryItemsPaginated.listLibraryItems(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLibraryItemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLibraryItemsResponse]
 */
public fun QAppsClient.listLibraryItemsPaginated(block: ListLibraryItemsRequest.Builder.() -> Unit): Flow<ListLibraryItemsResponse> =
    listLibraryItemsPaginated(ListLibraryItemsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLibraryItemsPaginated]
 * to access the nested member [LibraryItemMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LibraryItemMember]
 */
@JvmName("listLibraryItemsResponseLibraryItemMember")
public fun Flow<ListLibraryItemsResponse>.libraryItems(): Flow<LibraryItemMember> =
    transform() { response ->
        response.libraryItems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQAppsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQAppsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQAppsResponse]
 */
public fun QAppsClient.listQAppsPaginated(initialRequest: ListQAppsRequest): Flow<ListQAppsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQAppsPaginated.listQApps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListQAppsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQAppsResponse]
 */
public fun QAppsClient.listQAppsPaginated(block: ListQAppsRequest.Builder.() -> Unit): Flow<ListQAppsResponse> =
    listQAppsPaginated(ListQAppsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listQAppsPaginated]
 * to access the nested member [UserAppItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserAppItem]
 */
@JvmName("listQAppsResponseUserAppItem")
public fun Flow<ListQAppsResponse>.apps(): Flow<UserAppItem> =
    transform() { response ->
        response.apps?.forEach {
            emit(it)
        }
    }
